/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.net;

import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.net.HttpHelper;
import com.android.tradefed.util.net.IHttpHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class HttpMultipartPost {
    private static final String CONTENT_TYPE = "text/plain";
    private static final String BOUNDARY = "xXxXx";
    private static final String HYPHENS = "--";
    private static final String CRLF = "\r\n";
    private StringBuilder mBuilder = new StringBuilder();
    private String mUrl;
    private IHttpHelper mHelper;

    public HttpMultipartPost(String url, IHttpHelper httpHelper) {
        this.mUrl = url;
        this.mHelper = httpHelper;
    }

    public HttpMultipartPost(String url) {
        this(url, new HttpHelper());
    }

    public void addParameter(String name, String value) throws IOException {
        this.mBuilder.append("--xXxXx\r\n");
        this.mBuilder.append(String.format("Content-Disposition: form-data; name=\"%s\"%s%s", name, CRLF, CRLF));
        this.mBuilder.append(value);
        this.mBuilder.append(CRLF);
    }

    public void addTextFile(String name, File file2) throws IOException {
        FileInputStream in = new FileInputStream(file2);
        String fileName = file2.getAbsolutePath();
        this.addTextFile(name, fileName, in);
        in.close();
    }

    public void addTextFile(String name, String fileName, InputStream in) throws IOException {
        this.mBuilder.append("--xXxXx\r\n");
        this.mBuilder.append(String.format("Content-Disposition: form-data; name=\"%s\";filename=\"%s\"%s", name, fileName, CRLF));
        this.mBuilder.append(String.format("Content-Type: %s%s", CONTENT_TYPE, CRLF));
        this.mBuilder.append(CRLF);
        this.mBuilder.append(StreamUtil.getStringFromStream(in));
        this.mBuilder.append(CRLF);
    }

    public void send() throws IOException, IHttpHelper.DataSizeException {
        this.mBuilder.append("--xXxXx--");
        this.mBuilder.append("\r\n\r\n");
        this.mHelper.doPostWithRetry(this.mUrl, this.mBuilder.toString(), "multipart/form-data;boundary=xXxXx");
    }
}

