/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.proto;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class TfMetricProtoUtil {
    public static Map<String, String> compatibleConvert(Map<String, MetricMeasurement.Metric> map) {
        LinkedHashMap<String, String> oldFormat = new LinkedHashMap<String, String>();
        block6: for (String key : map.keySet()) {
            MetricMeasurement.Measurements measures = map.get(key).getMeasurements();
            MetricMeasurement.Measurements.MeasurementCase set = measures.getMeasurementCase();
            String value = "";
            switch (set) {
                case SINGLE_DOUBLE: {
                    value = Double.toString(measures.getSingleDouble());
                    break;
                }
                case SINGLE_INT: {
                    value = Long.toString(measures.getSingleInt());
                    break;
                }
                case SINGLE_STRING: {
                    value = measures.getSingleString();
                    break;
                }
                case MEASUREMENT_NOT_SET: {
                    LogUtil.CLog.d("No measurements was set for key '%s'", key);
                    continue block6;
                }
                default: {
                    LogUtil.CLog.d("Could not convert complex '%s' type to String. Use the new metric interface.", set);
                    continue block6;
                }
            }
            oldFormat.put(key, value);
        }
        return oldFormat;
    }

    public static HashMap<String, MetricMeasurement.Metric> upgradeConvert(Map<String, String> metrics) {
        return TfMetricProtoUtil.upgradeConvert(metrics, false);
    }

    public static HashMap<String, MetricMeasurement.Metric> upgradeConvert(Map<String, String> metrics, boolean smartNumbers) {
        LinkedHashMap<String, MetricMeasurement.Metric> newFormat = new LinkedHashMap<String, MetricMeasurement.Metric>();
        for (String key : metrics.keySet()) {
            Long numMetric;
            MetricMeasurement.Metric metric = null;
            String stringMetric = metrics.get(key);
            if (smartNumbers && (numMetric = TfMetricProtoUtil.isLong(stringMetric)) != null) {
                metric = TfMetricProtoUtil.createSingleValue(numMetric, null);
            }
            if (metric == null) {
                metric = TfMetricProtoUtil.stringToMetric(stringMetric);
            }
            newFormat.put(key, metric);
        }
        return newFormat;
    }

    private static Long isLong(String strNum) {
        if (strNum == null) {
            return null;
        }
        try {
            return Long.parseLong(strNum);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static MetricMeasurement.Metric stringToMetric(String metric) {
        MetricMeasurement.Measurements measures = MetricMeasurement.Measurements.newBuilder().setSingleString(metric).build();
        MetricMeasurement.Metric m = MetricMeasurement.Metric.newBuilder().setMeasurements(measures).setDirection(MetricMeasurement.Directionality.DIRECTIONALITY_UNSPECIFIED).setType(MetricMeasurement.DataType.RAW).build();
        return m;
    }

    public static MetricMeasurement.Metric createSingleValue(long value, String unit) {
        MetricMeasurement.Measurements measure = MetricMeasurement.Measurements.newBuilder().setSingleInt(value).build();
        MetricMeasurement.Metric.Builder metricBuilder = MetricMeasurement.Metric.newBuilder().setType(MetricMeasurement.DataType.RAW).setMeasurements(measure);
        if (unit != null) {
            metricBuilder.setUnit(unit);
        }
        return metricBuilder.build();
    }
}

