/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.sl4a;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.sl4a.Sl4aEventDispatcher;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Sl4aClient
implements AutoCloseable {
    private static final String INIT = "initiate";
    public static final String IS_SL4A_RUNNING_CMD = "ps -e | grep \"S com.googlecode.android_scripting\"";
    public static final String IS_SL4A_RUNNING_CMD_OLD = "ps | grep \"S com.googlecode.android_scripting\"";
    public static final String SL4A_LAUNCH_CMD = "am start -a com.googlecode.android_scripting.action.LAUNCH_SERVER --ei com.googlecode.android_scripting.extra.USE_SERVICE_PORT %s com.googlecode.android_scripting/.activity.ScriptingLayerServiceLauncher";
    public static final String STOP_SL4A_CMD = "am force-stop com.googlecode.android_scripting";
    private static final int UNKNOWN_ID = -1;
    private ITestDevice mDevice;
    private int mHostPort;
    private int mDeviceSidePort;
    private Socket mSocket;
    private Long mCounter = 1L;
    private int mUid = -1;
    private Sl4aEventDispatcher mEventDispatcher;

    public Sl4aClient(ITestDevice device, int hostPort, int devicePort) {
        this.mDevice = device;
        this.mHostPort = hostPort;
        this.mDeviceSidePort = devicePort;
    }

    public Sl4aClient(ITestDevice device, File sl4aApkFile) throws DeviceNotAvailableException {
        Sl4aClient.installSl4a(device, sl4aApkFile);
        ServerSocket s = null;
        int port = -1;
        try {
            s = new ServerSocket(0);
            s.setReuseAddress(true);
            port = s.getLocalPort();
            s.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.mDevice = device;
        this.mHostPort = port;
        this.mDeviceSidePort = 9998;
    }

    private static void installSl4a(ITestDevice device, File sl4aApkFile) throws DeviceNotAvailableException {
        if (sl4aApkFile != null) {
            if (!sl4aApkFile.exists()) {
                throw new RuntimeException(String.format("Sl4A apk '%s' was not found.", sl4aApkFile.getAbsoluteFile()));
            }
            String res = device.installPackage(sl4aApkFile, true, new String[0]);
            if (res != null) {
                throw new RuntimeException(String.format("Error when installing the Sl4A apk: %s", res));
            }
        }
    }

    public static Sl4aClient startSL4A(ITestDevice device, File sl4aApkFile) throws DeviceNotAvailableException {
        Sl4aClient.installSl4a(device, sl4aApkFile);
        ServerSocket s = null;
        int port = -1;
        try {
            s = new ServerSocket(0);
            s.setReuseAddress(true);
            port = s.getLocalPort();
            s.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Sl4aClient sl4aClient = new Sl4aClient(device, port, 9998);
        sl4aClient.startSl4A();
        return sl4aClient;
    }

    protected IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    public void startSl4A() throws DeviceNotAvailableException {
        this.mDevice.executeShellCommand(String.format(SL4A_LAUNCH_CMD, this.mDeviceSidePort));
        this.getRunUtil().sleep(2000L);
        if (!this.isSl4ARunning()) {
            throw new RuntimeException("sl4a is not running.");
        }
        this.open();
    }

    public boolean isSl4ARunning() throws DeviceNotAvailableException {
        String out1 = this.mDevice.executeShellCommand(IS_SL4A_RUNNING_CMD_OLD);
        String out2 = this.mDevice.executeShellCommand(IS_SL4A_RUNNING_CMD);
        if (out1 == null || out2 == null) {
            LogUtil.CLog.i("Null string return");
            return false;
        }
        if (out1.trim().isEmpty() && out2.trim().isEmpty()) {
            LogUtil.CLog.i("Empty return");
            return false;
        }
        return true;
    }

    public void open() {
        try {
            this.mDevice.executeAdbCommand("forward", "tcp:" + this.mHostPort, "tcp:" + this.mDeviceSidePort);
            String res = this.mDevice.executeAdbCommand("forward", "--list");
            LogUtil.CLog.d("forwardings: %s", res);
            this.mSocket = new Socket("localhost", this.mHostPort);
            LogUtil.CLog.i("is sl4a socket connected: %s", this.mSocket.isConnected());
            String rep = this.sendCommand(INIT);
            LogUtil.CLog.i("response sl4a INIT: '%s', from device %s", rep, this.mDevice.getSerialNumber());
            JSONObject init = new JSONObject(rep);
            this.mUid = init.getInt("uid");
            this.startEventDispatcher();
        }
        catch (DeviceNotAvailableException | IOException | JSONException e) {
            throw new RuntimeException(e);
        }
    }

    protected void startEventDispatcher() throws DeviceNotAvailableException {
        if (!this.isSl4ARunning()) {
            throw new RuntimeException("sl4a is not running.");
        }
        this.mEventDispatcher = new Sl4aEventDispatcher(this, 5000L);
        this.mEventDispatcher.start();
    }

    private String sendCommand(String cmd) throws IOException {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("cmd", cmd);
        info.put("uid", this.mUid + "");
        JSONObject message2 = new JSONObject(info);
        PrintWriter out = new PrintWriter(this.mSocket.getOutputStream(), true);
        out.print(message2.toString());
        out.print('\n');
        LogUtil.CLog.d("flushing");
        out.flush();
        LogUtil.CLog.d("sent");
        BufferedReader in = new BufferedReader(new InputStreamReader(this.mSocket.getInputStream()));
        LogUtil.CLog.d("reading");
        String response = in.readLine();
        return response;
    }

    private synchronized Object sendThroughSocket(String message2) throws IOException {
        LogUtil.CLog.v("preparing sending: '%s' to device %s", message2, this.mDevice.getSerialNumber());
        PrintWriter out = new PrintWriter(this.mSocket.getOutputStream(), false);
        out.print(message2);
        out.print('\n');
        out.flush();
        BufferedReader in = new BufferedReader(new InputStreamReader(this.mSocket.getInputStream()));
        String response = in.readLine();
        LogUtil.CLog.v("response: '%s' from device %s", response, this.mDevice.getSerialNumber());
        try {
            JSONObject resp = new JSONObject(response);
            if (!resp.isNull("error")) {
                throw new IOException(String.format("RPC error: %s", resp.get("error")));
            }
            if (resp.isNull("result")) {
                return null;
            }
            return resp.get("result");
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() {
        try {
            if (this.mEventDispatcher != null) {
                this.mEventDispatcher.cancel();
            }
            if (this.mSocket != null) {
                this.mSocket.close();
            }
            this.mDevice.executeShellCommand(STOP_SL4A_CMD);
            this.mDevice.executeAdbCommand("forward", "--remove", "tcp:" + this.mHostPort);
        }
        catch (DeviceNotAvailableException | IOException e) {
            LogUtil.CLog.e(e);
        }
    }

    public Object rpcCall(String methodName, Object ... args) throws IOException {
        JSONArray argsFormatted = new JSONArray();
        if (args != null) {
            for (Object arg : args) {
                argsFormatted.put(arg);
            }
        }
        JSONObject message2 = new JSONObject();
        try {
            message2.put("id", this.mCounter);
            message2.put("method", methodName);
            message2.put("params", argsFormatted);
        }
        catch (JSONException e) {
            LogUtil.CLog.e(e);
            throw new IOException("Failed to format the message", e);
        }
        Long l = this.mCounter;
        this.mCounter = this.mCounter + 1L;
        return this.sendThroughSocket(message2.toString());
    }

    public Sl4aEventDispatcher getEventDispatcher() {
        return this.mEventDispatcher;
    }
}

