/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.sl4a;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.sl4a.Sl4aClient;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.json.JSONException;
import org.json.JSONObject;

public class Sl4aEventDispatcher
extends Thread {
    private Sl4aClient mClient;
    private long mTimeout;
    public static final String SHUTDOWN_EVENT = "EventDispatcherShutdown";
    private Map<String, LinkedList<EventSl4aObject>> mEventQueue = new HashMap<String, LinkedList<EventSl4aObject>>();
    private boolean mCanceled = false;

    public Sl4aEventDispatcher(Sl4aClient client, long timeout) {
        this.setName(this.getClass().getCanonicalName());
        this.setDaemon(true);
        this.mClient = client;
        this.mTimeout = timeout;
    }

    private void pollEvents() {
        while (!this.mCanceled && this.internalPolling()) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalPolling() {
        try {
            Object response = this.mClient.rpcCall("eventWait", this.mTimeout);
            if (response == null) {
                return true;
            }
            EventSl4aObject event = new EventSl4aObject(new JSONObject(response.toString()));
            if (SHUTDOWN_EVENT.equals(event.getName())) {
                this.mCanceled = true;
                return false;
            }
            Map<String, LinkedList<EventSl4aObject>> map = this.mEventQueue;
            synchronized (map) {
                if (this.mEventQueue.containsKey(event.getName())) {
                    this.mEventQueue.get(event.getName()).add(event);
                } else {
                    LinkedList<EventSl4aObject> queue = new LinkedList<EventSl4aObject>();
                    queue.add(event);
                    this.mEventQueue.put(event.getName(), queue);
                }
            }
        }
        catch (IOException e) {
            LogUtil.CLog.w("Error '%s' when polling the events.", e);
        }
        catch (JSONException e) {
            LogUtil.CLog.e(e);
        }
        return true;
    }

    @Override
    public void run() {
        this.pollEvents();
    }

    public void cancel() {
        this.mCanceled = true;
        this.interrupt();
        this.clearAllEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventSl4aObject popEvent(String name, long timeout) {
        long deadline = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < deadline) {
            Map<String, LinkedList<EventSl4aObject>> map = this.mEventQueue;
            synchronized (map) {
                EventSl4aObject res;
                if (this.mEventQueue.get(name) != null && (res = this.mEventQueue.get(name).poll()) != null) {
                    return res;
                }
            }
        }
        LogUtil.CLog.e("Timeout after waiting %sms for event '%s'", timeout, name);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventSl4aObject waitForEvent(String name, Predicate<EventSl4aObject> predicate, long timeout) {
        long deadline = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < deadline) {
            Map<String, LinkedList<EventSl4aObject>> map = this.mEventQueue;
            synchronized (map) {
                EventSl4aObject res;
                if (this.mEventQueue.get(name) != null && (res = this.mEventQueue.get(name).poll()) != null && predicate.test(res)) {
                    return res;
                }
            }
        }
        LogUtil.CLog.e("Timeout after waiting %sms for event '%s'", timeout, name);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EventSl4aObject> popAllEvents(String name) {
        Map<String, LinkedList<EventSl4aObject>> map = this.mEventQueue;
        synchronized (map) {
            if (this.mEventQueue.get(name) != null) {
                LinkedList<EventSl4aObject> results = new LinkedList<EventSl4aObject>();
                results.addAll((Collection)this.mEventQueue.get(name));
                this.mEventQueue.get(name).clear();
                return results;
            }
            return new LinkedList<EventSl4aObject>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearEvents(String name) {
        Map<String, LinkedList<EventSl4aObject>> map = this.mEventQueue;
        synchronized (map) {
            if (this.mEventQueue.get(name) != null) {
                this.mEventQueue.get(name).clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllEvents() {
        Map<String, LinkedList<EventSl4aObject>> map = this.mEventQueue;
        synchronized (map) {
            for (String key : this.mEventQueue.keySet()) {
                this.mEventQueue.get(key).clear();
            }
            this.mEventQueue.clear();
        }
    }

    public static class EventSl4aObject {
        private String mName = null;
        private String mData = null;
        private long mTime = 0L;

        public EventSl4aObject(JSONObject response) throws JSONException {
            this.mName = response.getString("name");
            this.mData = response.get("data").toString();
            this.mTime = response.getLong("time");
        }

        public String getName() {
            return this.mName;
        }

        public String getData() {
            return this.mData;
        }

        public long getTime() {
            return this.mTime;
        }

        public String toString() {
            return "EventSl4aObject [mName=" + this.mName + ", mData=" + this.mData + ", mTime=" + this.mTime + "]";
        }
    }
}

