/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.statsd;

import com.android.internal.os.StatsdConfigProto;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.FileUtil;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public class ConfigUtil {
    private static final String REMOVE_CONFIG_CMD = "cmd stats config remove";
    private static final String UPDATE_CONFIG_CMD = "cmd stats config update";

    public static long pushStatsConfig(ITestDevice device, List<Integer> eventAtomIds) throws IOException, DeviceNotAvailableException {
        return ConfigUtil.pushStatsConfig(device, eventAtomIds, ConfigUtil.commonLogSources());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long pushStatsConfig(ITestDevice device, List<Integer> eventAtomIds, List<LogSource> logSources) throws IOException, DeviceNotAvailableException {
        StatsdConfigProto.StatsdConfig config = ConfigUtil.generateStatsdConfig(eventAtomIds, logSources);
        LogUtil.CLog.d("Collecting atoms [%s] with the following config: %s", eventAtomIds.stream().map(String::valueOf).collect(Collectors.joining(", ")), config.toString());
        File configFile = null;
        try {
            configFile = File.createTempFile("statsdconfig", ".config");
            Files.write(config.toByteArray(), configFile);
            String remotePath = String.format("/data/local/tmp/%s", configFile.getName());
            if (!device.pushFile(configFile, remotePath)) {
                throw new RuntimeException("Failed to configuration push file to the device.");
            }
            ConfigUtil.updateConfig(device, remotePath, config.getId());
            long l = config.getId();
            return l;
        }
        finally {
            FileUtil.deleteFile(configFile);
        }
    }

    public static long pushBinaryStatsConfig(ITestDevice device, File configFile) throws IOException, DeviceNotAvailableException {
        if (!configFile.exists()) {
            throw new FileNotFoundException(String.format("File not found for statsd config: %s", configFile.getAbsolutePath()));
        }
        String remotePath = String.format("/data/local/tmp/%s", configFile.getName());
        if (device.pushFile(configFile, remotePath)) {
            long configId = UUID.randomUUID().hashCode();
            ConfigUtil.updateConfig(device, remotePath, configId);
            return configId;
        }
        throw new RuntimeException("Failed to push configuration file to the device.");
    }

    public static void removeConfig(ITestDevice device, long configId) throws DeviceNotAvailableException {
        device.executeShellCommand(String.join((CharSequence)" ", REMOVE_CONFIG_CMD, String.valueOf(configId)));
    }

    private static void updateConfig(ITestDevice device, String remotePath, long configId) throws DeviceNotAvailableException {
        CommandResult output = device.executeShellV2Command(String.join((CharSequence)" ", "cat", remotePath, "|", UPDATE_CONFIG_CMD, String.valueOf(configId)));
        device.deleteFile(remotePath);
        if (output.getStderr().contains("Error parsing")) {
            throw new RuntimeException("Failed to parse configuration file on the device.");
        }
        if (!output.getStderr().isEmpty()) {
            throw new RuntimeException(String.format("Failed to push config with error: %s.", output.getStderr()));
        }
    }

    private static StatsdConfigProto.StatsdConfig generateStatsdConfig(List<Integer> eventAtomIds, List<LogSource> logSources) {
        long configId = UUID.randomUUID().hashCode();
        StatsdConfigProto.StatsdConfig.Builder configBuilder = StatsdConfigProto.StatsdConfig.newBuilder().setId(configId).addAllAllowedLogSource(logSources.stream().map(Enum::name).collect(Collectors.toList()));
        for (Integer id : eventAtomIds) {
            long atomMatcherId = UUID.randomUUID().hashCode();
            long eventMatcherId = UUID.randomUUID().hashCode();
            configBuilder = configBuilder.addAtomMatcher(StatsdConfigProto.AtomMatcher.newBuilder().setId(atomMatcherId).setSimpleAtomMatcher(StatsdConfigProto.SimpleAtomMatcher.newBuilder().setAtomId(id))).addEventMetric(StatsdConfigProto.EventMetric.newBuilder().setId(eventMatcherId).setWhat(atomMatcherId));
        }
        return configBuilder.build();
    }

    private static List<LogSource> commonLogSources() {
        return Arrays.asList(LogSource.AID_BLUETOOTH, LogSource.AID_GRAPHICS, LogSource.AID_INCIDENTD, LogSource.AID_RADIO, LogSource.AID_ROOT, LogSource.AID_STATSD, LogSource.AID_SYSTEM);
    }

    public static enum LogSource {
        AID_BLUETOOTH,
        AID_GRAPHICS,
        AID_INCIDENTD,
        AID_RADIO,
        AID_ROOT,
        AID_STATSD,
        AID_SYSTEM,
        AID_MEDIA;

    }
}

