/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.testmapping;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.testmapping.TestOption;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class TestInfo {
    private static final String OPTION_INCLUDE_ANNOTATION = "include-annotation";
    private static final String OPTION_EXCLUDE_ANNOTATION = "exclude-annotation";
    private String mName = null;
    private List<TestOption> mOptions = new ArrayList<TestOption>();
    private Set<String> mSources = new HashSet<String>();
    private Set<String> mImportPaths = new HashSet<String>();
    private boolean mHostOnly = false;
    private Set<String> mKeywords = null;

    public TestInfo(String name, String source, boolean hostOnly) {
        this(name, source, hostOnly, new HashSet<String>());
    }

    public TestInfo(String name, String source, boolean hostOnly, Set<String> keywords) {
        this.mName = name;
        this.mSources.add(source);
        this.mHostOnly = hostOnly;
        this.mKeywords = keywords;
    }

    public String getName() {
        return this.mName;
    }

    public void addOption(TestOption option) {
        this.mOptions.add(option);
        Collections.sort(this.mOptions);
    }

    public List<TestOption> getOptions() {
        return this.mOptions;
    }

    public void addSources(Set<String> sources) {
        this.mSources.addAll(sources);
    }

    public void addImportPaths(Set<String> paths) {
        this.mImportPaths.addAll(paths);
    }

    public Set<String> getImportPaths() {
        return this.mImportPaths;
    }

    public Set<String> getSources() {
        return this.mSources;
    }

    public boolean getHostOnly() {
        return this.mHostOnly;
    }

    public String getNameAndHostOnly() {
        return String.format("%s - %s", this.mName, this.mHostOnly);
    }

    public String getNameOption() {
        return String.format("%s%s", this.mName, this.mOptions.toString());
    }

    public Set<String> getKeywords() {
        return new HashSet<String>(this.mKeywords);
    }

    public Set<String> getKeywords(Set<String> ignoreKeywords) {
        LinkedHashSet<String> keywords = new LinkedHashSet<String>(this.mKeywords);
        keywords.removeAll(ignoreKeywords);
        return keywords;
    }

    public void merge(TestInfo test) {
        LogUtil.CLog.d("Merging test %s and %s.", this, test);
        Preconditions.checkState(this.mName.equals(test.getName()), "Only TestInfo for the same module can be merged.");
        Preconditions.checkState(this.mHostOnly == test.getHostOnly(), "Only TestInfo for the same device requirement (running on device or host) can be merged.");
        ArrayList<TestOption> mergedOptions = new ArrayList<TestOption>();
        if (test.exclusiveOptionsOnly() || this.exclusiveOptionsOnly()) {
            HashSet<TestOption> commonOptions = new HashSet<TestOption>(test.getOptions());
            commonOptions.retainAll(new HashSet<TestOption>(this.mOptions));
            this.mOptions = new ArrayList<TestOption>(commonOptions);
            this.addSources(test.getSources());
            LogUtil.CLog.d("Options are merged, updated test: %s.", this);
            return;
        }
        Set nonExclusiveOptions = this.mOptions.stream().filter(option -> !option.isExclusive() && !OPTION_INCLUDE_ANNOTATION.equals(option.getName())).collect(Collectors.toSet());
        Set includeAnnotationOptions = this.mOptions.stream().filter(option -> OPTION_INCLUDE_ANNOTATION.equals(option.getName())).collect(Collectors.toSet());
        Set exclusiveOptions = this.mOptions.stream().filter(option -> option.isExclusive() && !OPTION_EXCLUDE_ANNOTATION.equals(option.getName())).collect(Collectors.toSet());
        Set excludeAnnotationOptions = this.mOptions.stream().filter(option -> OPTION_EXCLUDE_ANNOTATION.equals(option.getName())).collect(Collectors.toSet());
        Set nonExclusiveOptionsToMerge = test.getOptions().stream().filter(option -> !option.isExclusive() && !OPTION_INCLUDE_ANNOTATION.equals(option.getName())).collect(Collectors.toSet());
        Set includeAnnotationOptionsToMerge = test.getOptions().stream().filter(option -> OPTION_INCLUDE_ANNOTATION.equals(option.getName())).collect(Collectors.toSet());
        Set exclusiveOptionsToMerge = test.getOptions().stream().filter(option -> option.isExclusive() && !OPTION_EXCLUDE_ANNOTATION.equals(option.getName())).collect(Collectors.toSet());
        Set excludeAnnotationOptionsToMerge = test.getOptions().stream().filter(option -> OPTION_EXCLUDE_ANNOTATION.equals(option.getName())).collect(Collectors.toSet());
        nonExclusiveOptions.addAll(nonExclusiveOptionsToMerge);
        for (TestOption option2 : nonExclusiveOptions) {
            mergedOptions.add(option2);
        }
        exclusiveOptions.retainAll(exclusiveOptionsToMerge);
        for (TestOption option2 : exclusiveOptions) {
            mergedOptions.add(option2);
        }
        includeAnnotationOptions.retainAll(includeAnnotationOptionsToMerge);
        for (TestOption option2 : includeAnnotationOptions) {
            mergedOptions.add(option2);
        }
        excludeAnnotationOptions.addAll(excludeAnnotationOptionsToMerge);
        for (TestOption option2 : excludeAnnotationOptions) {
            mergedOptions.add(option2);
        }
        this.mOptions = mergedOptions;
        this.addSources(test.getSources());
        LogUtil.CLog.d("Options are merged, updated test: %s.", this);
    }

    private boolean exclusiveOptionsOnly() {
        for (TestOption option : this.mOptions) {
            if (!option.isInclusive()) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        return this.toString().equals(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append(this.mName);
        if (!this.mOptions.isEmpty()) {
            String options = String.format("Options: %s", String.join((CharSequence)",", this.mOptions.stream().sorted().map(TestOption::toString).collect(Collectors.toList())));
            string.append("\n\t").append(options);
        }
        if (!this.mKeywords.isEmpty()) {
            String keywords = String.format("Keywords: %s", String.join((CharSequence)",", this.mKeywords.stream().sorted().collect(Collectors.toList())));
            string.append("\n\t").append(keywords);
        }
        if (!this.mSources.isEmpty()) {
            String sources = String.format("Sources: %s", String.join((CharSequence)",", this.mSources.stream().sorted().collect(Collectors.toList())));
            string.append("\n\t").append(sources);
        }
        string.append("\n\tHost: ").append(this.mHostOnly);
        return string.toString();
    }
}

