/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.testmapping;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.ZipUtil2;
import com.android.tradefed.util.testmapping.TestInfo;
import com.android.tradefed.util.testmapping.TestOption;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class TestMapping {
    public static final String TEST_SOURCES = "Test Sources";
    public static final Pattern MAINLINE_REGEX = Pattern.compile("(\\S+)\\[(\\S+)\\]");
    private static final String PRESUBMIT = "presubmit";
    private static final String IMPORTS = "imports";
    private static final String KEY_IMPORT_PATH = "path";
    private static final String KEY_HOST = "host";
    private static final String KEY_KEYWORDS = "keywords";
    private static final String KEY_FILE_PATTERNS = "file_patterns";
    private static final String KEY_NAME = "name";
    private static final String KEY_OPTIONS = "options";
    private static final String TEST_MAPPING = "TEST_MAPPING";
    public static final String TEST_MAPPINGS_ZIP = "test_mappings.zip";
    private static final String DISABLED_PRESUBMIT_TESTS_FILE = "disabled-presubmit-tests";
    private static final Pattern COMMENTS_REGEX = Pattern.compile("(?m)[\\s\\t]*(//|#).*|(\".*?\")");
    private static final Set<String> COMMENTS = new HashSet<String>(Arrays.asList("#", "//"));
    private List<String> mTestMappingRelativePaths = new ArrayList<String>();
    private boolean mIgnoreTestMappingImports = true;

    public TestMapping() {
        this(new ArrayList<String>(), true);
    }

    public TestMapping(List<String> testMappingRelativePaths, boolean ignoreTestMappingImports) {
        this.mTestMappingRelativePaths = testMappingRelativePaths;
        this.mIgnoreTestMappingImports = ignoreTestMappingImports;
    }

    @VisibleForTesting
    Map<String, Set<TestInfo>> getTestCollection(Path path, Path testMappingsDir, Set<String> matchedPatternPaths) {
        LinkedHashMap<String, Set<TestInfo>> testCollection = new LinkedHashMap<String, Set<TestInfo>>();
        String relativePath = testMappingsDir.relativize(path.getParent()).toString();
        String errorMessage = null;
        if (Files.notExists(path, new LinkOption[0])) {
            LogUtil.CLog.d("TEST_MAPPING path not found: %s.", path);
            return testCollection;
        }
        try {
            String content = this.removeComments(String.join((CharSequence)"\n", Files.readAllLines(path, StandardCharsets.UTF_8)));
            if (Strings.isNullOrEmpty(content)) {
                return testCollection;
            }
            JSONTokener tokener = new JSONTokener(content);
            JSONObject root = new JSONObject(tokener);
            Iterator testGroups = root.keys();
            HashSet<Path> filePaths = new HashSet<Path>();
            if (!this.mIgnoreTestMappingImports) {
                this.listTestMappingFiles(path.getParent(), testMappingsDir, filePaths);
            }
            while (testGroups.hasNext()) {
                String group = (String)testGroups.next();
                if (group.equals(IMPORTS)) continue;
                LinkedHashSet<TestInfo> testsForGroup = new LinkedHashSet<TestInfo>();
                testCollection.put(group, testsForGroup);
                JSONArray arr = root.getJSONArray(group);
                for (int i = 0; i < arr.length(); ++i) {
                    JSONObject testObject = arr.getJSONObject(i);
                    boolean hostOnly = testObject.has(KEY_HOST) && testObject.getBoolean(KEY_HOST);
                    HashSet<String> keywords = new HashSet<String>();
                    if (testObject.has(KEY_KEYWORDS)) {
                        JSONArray keywordArray = testObject.getJSONArray(KEY_KEYWORDS);
                        for (int j = 0; j < keywordArray.length(); ++j) {
                            keywords.add(keywordArray.getString(j));
                        }
                    }
                    HashSet<String> filePatterns = new HashSet<String>();
                    if (testObject.has(KEY_FILE_PATTERNS)) {
                        JSONArray filePatternArray = testObject.getJSONArray(KEY_FILE_PATTERNS);
                        for (int k = 0; k < filePatternArray.length(); ++k) {
                            filePatterns.add(filePatternArray.getString(k));
                        }
                    }
                    if (!this.isMatchedFilePatterns(relativePath, matchedPatternPaths, filePatterns)) continue;
                    TestInfo test = new TestInfo(testObject.getString(KEY_NAME), relativePath, hostOnly, keywords);
                    if (testObject.has(KEY_OPTIONS)) {
                        JSONArray optionObjects = testObject.getJSONArray(KEY_OPTIONS);
                        for (int j = 0; j < optionObjects.length(); ++j) {
                            JSONObject optionObject = optionObjects.getJSONObject(j);
                            for (int k = 0; k < optionObject.names().length(); ++k) {
                                String name = optionObject.names().getString(k);
                                String value = optionObject.getString(name);
                                TestOption option = new TestOption(name, value);
                                test.addOption(option);
                            }
                        }
                    }
                    for (Path filePath : filePaths) {
                        Path importPath = testMappingsDir.relativize(filePath).getParent();
                        if (test.getSources().contains(importPath.toString())) continue;
                        test.addImportPaths(Collections.singleton(importPath.toString()));
                    }
                    testsForGroup.add(test);
                }
            }
            if (!this.mIgnoreTestMappingImports) {
                for (Path filePath : filePaths) {
                    Map<String, Set<TestInfo>> filePathImportedTestCollection = new TestMapping(this.mTestMappingRelativePaths, true).getTestCollection(filePath, testMappingsDir, matchedPatternPaths);
                    for (String group : filePathImportedTestCollection.keySet()) {
                        if (filePathImportedTestCollection.get(group) == null) continue;
                        if (testCollection.get(group) == null) {
                            testCollection.put(group, filePathImportedTestCollection.get(group));
                            continue;
                        }
                        ((Set)testCollection.get(group)).addAll((Collection)filePathImportedTestCollection.get(group));
                    }
                }
            }
        }
        catch (IOException e) {
            errorMessage = String.format("TEST_MAPPING file does not exist: %s.", path.toString());
            LogUtil.CLog.e(errorMessage);
        }
        catch (JSONException e) {
            errorMessage = String.format("Error parsing TEST_MAPPING file: %s. Error: %s", path.toString(), e);
        }
        if (errorMessage != null) {
            LogUtil.CLog.e(errorMessage);
            throw new HarnessRuntimeException(errorMessage, InfraErrorIdentifier.TEST_MAPPING_FILE_FORMAT_ISSUE);
        }
        return testCollection;
    }

    private boolean isMatchedFilePatterns(String testMappingDir, Set<String> matchedPatternPaths, Set<String> filePatterns) {
        HashSet<String> matchedPatternPathsInSource = new HashSet<String>();
        for (String matchedPatternPath : matchedPatternPaths) {
            if (!matchedPatternPath.matches(String.join((CharSequence)File.separator, testMappingDir, ".*"))) continue;
            Path relativePath = Paths.get(testMappingDir, new String[0]).relativize(Paths.get(matchedPatternPath, new String[0]));
            matchedPatternPathsInSource.add(relativePath.toString());
        }
        if (this.mTestMappingRelativePaths.isEmpty() || filePatterns.isEmpty()) {
            return true;
        }
        for (String matchedPatternPathInSource : matchedPatternPathsInSource) {
            Path matchedPatternFilePath = Paths.get(matchedPatternPathInSource, new String[0]);
            if (matchedPatternFilePath.getFileName().toString().equals(TEST_MAPPING)) {
                return true;
            }
            for (String filePattern : filePatterns) {
                if (!matchedPatternPathInSource.matches(filePattern)) continue;
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    String removeComments(String jsonContent) {
        StringBuffer out = new StringBuffer();
        Matcher matcher = COMMENTS_REGEX.matcher(jsonContent);
        while (matcher.find()) {
            if (!COMMENTS.contains(matcher.group(1))) continue;
            matcher.appendReplacement(out, "");
        }
        matcher.appendTail(out);
        return out.toString();
    }

    public void listTestMappingFiles(Path testMappingDir, Path testMappingsRootDir, Set<Path> filePaths) {
        String errorMessage = null;
        if (!testMappingDir.toAbsolutePath().startsWith(testMappingsRootDir.toAbsolutePath())) {
            LogUtil.CLog.d("SKIPPED: Path %s is not under test mapping directory %s.", testMappingDir, testMappingsRootDir);
            return;
        }
        if (Files.notExists(testMappingDir, new LinkOption[0])) {
            LogUtil.CLog.d("TEST_MAPPING path not found: %s.", testMappingDir);
            return;
        }
        try {
            Path testMappingPath = testMappingDir.resolve(TEST_MAPPING);
            filePaths.add(testMappingPath);
            String content = this.removeComments(String.join((CharSequence)"\n", Files.readAllLines(testMappingPath, StandardCharsets.UTF_8)));
            if (Strings.isNullOrEmpty(content)) {
                return;
            }
            JSONTokener tokener = new JSONTokener(content);
            JSONObject root = new JSONObject(tokener);
            if (root.has(IMPORTS) && !this.mIgnoreTestMappingImports) {
                JSONArray arr = root.getJSONArray(IMPORTS);
                for (int i = 0; i < arr.length(); ++i) {
                    JSONObject testObject = arr.getJSONObject(i);
                    Path importPath = Paths.get(testObject.getString(KEY_IMPORT_PATH), new String[0]);
                    Path normImportPath = Paths.get(testMappingsRootDir.toString(), importPath.toString());
                    Path importPathTestMappingPath = normImportPath.resolve(TEST_MAPPING);
                    if (filePaths.contains(importPathTestMappingPath)) continue;
                    if (Files.exists(importPathTestMappingPath, new LinkOption[0])) {
                        filePaths.add(importPathTestMappingPath);
                    }
                    this.listTestMappingFiles(importPath, testMappingsRootDir, filePaths);
                }
            }
            while (testMappingDir.toAbsolutePath().startsWith(testMappingsRootDir.toAbsolutePath()) && !testMappingDir.toAbsolutePath().equals(testMappingsRootDir.toAbsolutePath())) {
                Path upperDirectory = testMappingDir.getParent();
                Path upperDirectoryTestMappingPath = upperDirectory.resolve(TEST_MAPPING);
                if (Files.exists(upperDirectoryTestMappingPath, new LinkOption[0]) && !filePaths.contains(upperDirectoryTestMappingPath)) {
                    filePaths.add(upperDirectoryTestMappingPath);
                    this.listTestMappingFiles(upperDirectory, testMappingsRootDir, filePaths);
                }
                testMappingDir = upperDirectory;
            }
        }
        catch (IOException e) {
            errorMessage = String.format("Error reading TEST_MAPPING file: %s.", testMappingDir.toString());
        }
        catch (JSONException e) {
            errorMessage = String.format("Error parsing TEST_MAPPING file: %s. Error: %s", testMappingDir.toString(), e);
        }
        if (errorMessage != null) {
            LogUtil.CLog.e(errorMessage);
            throw new RuntimeException(errorMessage);
        }
    }

    @VisibleForTesting
    Set<TestInfo> getTests(Map<String, Set<TestInfo>> testCollection, String testGroup, Set<String> disabledTests, boolean hostOnly, Set<String> keywords, Set<String> ignoreKeywords) {
        LinkedHashSet<TestInfo> tests = new LinkedHashSet<TestInfo>();
        for (TestInfo test : (Set)testCollection.getOrDefault(testGroup, new HashSet())) {
            if (disabledTests != null && disabledTests.contains(test.getName()) || test.getHostOnly() != hostOnly) continue;
            Set<String> testKeywords = test.getKeywords(ignoreKeywords);
            if ((keywords == null || keywords.isEmpty()) && !testKeywords.isEmpty()) continue;
            if (keywords != null) {
                boolean allKeywordsFound = true;
                for (String keyword : keywords) {
                    if (testKeywords.contains(keyword)) continue;
                    allKeywordsFound = false;
                    break;
                }
                if (!allKeywordsFound) continue;
            }
            tests.add(test);
        }
        return tests;
    }

    public Set<TestInfo> getTests(IBuildInfo buildInfo, String testGroup, boolean hostOnly, Set<String> keywords, Set<String> ignoreKeywords) {
        return this.getTests(buildInfo, testGroup, hostOnly, keywords, ignoreKeywords, new ArrayList<String>(), new HashSet<String>());
    }

    public Set<TestInfo> getTests(IBuildInfo buildInfo, String testGroup, boolean hostOnly, Set<String> keywords, Set<String> ignoreKeywords, List<String> extraZipNames, Set<String> matchedPatternPaths) {
        Set<TestInfo> tests = Collections.synchronizedSet(new LinkedHashSet());
        File zipFile = buildInfo == null ? this.lookupTestMappingZip(TEST_MAPPINGS_ZIP) : buildInfo.getFile(TEST_MAPPINGS_ZIP);
        File testMappingsDir = TestMapping.extractTestMappingsZip(zipFile);
        Path testMappingsRootPath = Paths.get(testMappingsDir.getAbsolutePath(), new String[0]);
        LogUtil.CLog.d("Relative test mapping paths: %s", this.mTestMappingRelativePaths);
        try (Stream stream = this.mTestMappingRelativePaths.isEmpty() ? Files.walk(testMappingsRootPath, FileVisitOption.FOLLOW_LINKS) : this.getAllTestMappingPaths(testMappingsRootPath).stream();){
            this.mergeTestMappingZips(buildInfo, extraZipNames, zipFile, testMappingsDir);
            Set<String> disabledTests = this.getDisabledTests(testMappingsRootPath, testGroup);
            stream.filter(path -> path.getFileName().toString().equals(TEST_MAPPING)).forEach(path -> tests.addAll(this.getTests(this.getTestCollection((Path)path, testMappingsRootPath, matchedPatternPaths), testGroup, disabledTests, hostOnly, keywords, ignoreKeywords)));
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("IO exception (%s) when reading tests from TEST_MAPPING files (%s)", e.getMessage(), testMappingsDir.getAbsolutePath()), e);
        }
        finally {
            FileUtil.recursiveDelete(testMappingsDir);
        }
        return tests;
    }

    @VisibleForTesting
    Set<Path> getAllTestMappingPaths(Path testMappingsRootPath) {
        LinkedHashSet<Path> allTestMappingPaths = new LinkedHashSet<Path>();
        for (String path : this.mTestMappingRelativePaths) {
            boolean hasAdded = false;
            Path testMappingPath = testMappingsRootPath.resolve(path);
            while (!testMappingPath.equals(testMappingsRootPath)) {
                if (testMappingPath.resolve(TEST_MAPPING).toFile().exists()) {
                    hasAdded = true;
                    LogUtil.CLog.d("Adding TEST_MAPPING path: %s", testMappingPath);
                    allTestMappingPaths.add(testMappingPath.resolve(TEST_MAPPING));
                }
                testMappingPath = testMappingPath.getParent();
            }
            if (hasAdded) continue;
            LogUtil.CLog.w("Couldn't find TEST_MAPPING files from %s", path);
        }
        if (allTestMappingPaths.isEmpty()) {
            throw new RuntimeException(String.format("Couldn't find TEST_MAPPING files from %s", this.mTestMappingRelativePaths));
        }
        LogUtil.CLog.d("All resolved TEST_MAPPING paths: %s", allTestMappingPaths);
        return allTestMappingPaths;
    }

    public Map<String, Set<TestInfo>> getAllTests(File testMappingsDir) {
        HashMap<String, Set<TestInfo>> allTests = new HashMap<String, Set<TestInfo>>();
        Path testMappingsRootPath = Paths.get(testMappingsDir.getAbsolutePath(), new String[0]);
        try (Stream<Path> stream = Files.walk(testMappingsRootPath, FileVisitOption.FOLLOW_LINKS);){
            stream.filter(path -> path.getFileName().toString().equals(TEST_MAPPING)).forEach(path -> this.getAllTests((Map<String, Set<TestInfo>>)allTests, (Path)path, testMappingsRootPath));
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("IO exception (%s) when reading tests from TEST_MAPPING files (%s)", e.getMessage(), testMappingsDir.getAbsolutePath()), e);
        }
        return allTests;
    }

    private void getAllTests(Map<String, Set<TestInfo>> allTests, Path path, Path testMappingsRootPath) {
        Map<String, Set<TestInfo>> testCollection = this.getTestCollection(path, testMappingsRootPath, new HashSet<String>());
        for (String group : testCollection.keySet()) {
            allTests.computeIfAbsent(group, k -> new HashSet()).addAll((Collection)testCollection.get(group));
        }
    }

    public static File extractTestMappingsZip(File testMappingsZip) {
        File testMappingsDir = null;
        try {
            testMappingsDir = ZipUtil2.extractZipToTemp(testMappingsZip, TEST_MAPPINGS_ZIP);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("IO exception (%s) when extracting test mappings zip (%s)", e.getMessage(), testMappingsZip.getAbsolutePath()), e);
        }
        return testMappingsDir;
    }

    @VisibleForTesting
    Set<String> getDisabledTests(Path testMappingsRootPath, String testGroup) {
        HashSet<String> disabledTests = new HashSet<String>();
        File disabledPresubmitTestsFile = new File(testMappingsRootPath.toString(), DISABLED_PRESUBMIT_TESTS_FILE);
        if (!testGroup.equals(PRESUBMIT) || !disabledPresubmitTestsFile.exists()) {
            return disabledTests;
        }
        try {
            disabledTests.addAll(Arrays.asList(FileUtil.readStringFromFile(disabledPresubmitTestsFile).split("\\r?\\n")));
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("IO exception (%s) when reading disabled tests from file (%s)", e.getMessage(), disabledPresubmitTestsFile.getAbsolutePath()), e);
        }
        return disabledTests;
    }

    public static Matcher getMainlineTestModuleName(TestInfo info) throws ConfigurationException {
        Matcher matcher = MAINLINE_REGEX.matcher(info.getName());
        if (matcher.find()) {
            return matcher;
        }
        throw new ConfigurationException(String.format("Unmatched \"[]\" for \"%s\" configured in the %s. Parameter must contain square brackets.", info.getName(), info.getSources()));
    }

    @VisibleForTesting
    void mergeTestMappingZips(IBuildInfo buildInfo, List<String> extraZips, File baseFile, File baseDir) throws IOException {
        if (extraZips.isEmpty()) {
            return;
        }
        Set<String> baseNames = this.getTestMappingSources(baseFile);
        for (String zipName : extraZips) {
            File zipFile = buildInfo == null ? this.lookupTestMappingZip(zipName) : buildInfo.getFile(zipName);
            if (zipFile == null) {
                throw new HarnessRuntimeException(String.format("Missing %s in the BuildInfo file.", zipName), InfraErrorIdentifier.ARTIFACT_NOT_FOUND);
            }
            Set<String> targetNames = this.getTestMappingSources(zipFile);
            this.validateSources(baseNames, targetNames, zipName);
            baseNames.addAll(targetNames);
            ZipUtil2.extractZip(zipFile, baseDir);
        }
    }

    private void validateSources(Set<String> base, Set<String> target, String zipName) {
        for (String name : target) {
            if (!base.contains(name)) continue;
            throw new HarnessRuntimeException(String.format("Collision of Test Mapping file: %s in artifact: %s.", name, zipName), InfraErrorIdentifier.TEST_MAPPING_PATH_COLLISION);
        }
    }

    @VisibleForTesting
    Set<String> getTestMappingSources(File zipFile) {
        HashSet<String> fileNames = new HashSet<String>();
        Enumeration<ZipArchiveEntry> entries = null;
        ZipFile f = null;
        try {
            f = new ZipFile(zipFile);
            entries = f.getEntries();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(String.format("IO exception (%s) when accessing test_mappings.zip (%s)", e.getMessage(), zipFile), e);
            }
            catch (Throwable throwable) {
                ZipUtil2.closeZip(f);
                throw throwable;
            }
        }
        ZipUtil2.closeZip(f);
        while (entries.hasMoreElements()) {
            ZipArchiveEntry entry = entries.nextElement();
            if (entry.isDirectory() || entry.getName().equals(DISABLED_PRESUBMIT_TESTS_FILE)) continue;
            fileNames.add(entry.getName());
        }
        return fileNames;
    }

    private File lookupTestMappingZip(String zipName) {
        String directFile = System.getenv("TF_TEST_MAPPING_ZIP_FILE");
        if (directFile != null && new File(directFile).exists()) {
            return new File(directFile);
        }
        throw new HarnessRuntimeException(String.format("Unable to locate the test mapping zip file %s", zipName), InfraErrorIdentifier.TEST_MAPPING_FILE_NOT_EXIST);
    }
}

