/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.zip;

import com.android.tradefed.util.ByteArrayUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Arrays;

public final class CentralDirectoryInfo {
    private static final byte[] CENTRAL_DIRECTORY_SIGNATURE = new byte[]{80, 75, 1, 2};
    private static final int ZIP64_EXTRA_FIELD_HEADER_ID = 1;
    private int mCompressionMethod;
    private long mCrc;
    private long mCompressedSize;
    private long mUncompressedSize;
    private long mLocalHeaderOffset;
    private int mInternalFileAttributes;
    private long mExternalFileAttributes;
    private String mFileName;
    private int mFileNameLength;
    private int mExtraFieldLength;
    private int mFileCommentLength;

    public int getCompressionMethod() {
        return this.mCompressionMethod;
    }

    public void setCompressionMethod(int compressionMethod) {
        this.mCompressionMethod = compressionMethod;
    }

    public long getCrc() {
        return this.mCrc;
    }

    public void setCrc(long crc) {
        this.mCrc = crc;
    }

    public int getCompressedSize() {
        return (int)this.mCompressedSize;
    }

    public void setCompressedSize(long compressionSize) {
        this.mCompressedSize = compressionSize;
    }

    public long getUncompressedSize() {
        return this.mUncompressedSize;
    }

    public void setUncompressedSize(long uncompressedSize) {
        this.mUncompressedSize = uncompressedSize;
    }

    public long getLocalHeaderOffset() {
        return this.mLocalHeaderOffset;
    }

    public void setLocalHeaderOffset(long localHeaderOffset) {
        this.mLocalHeaderOffset = localHeaderOffset;
    }

    public int getInternalFileAttributes() {
        return this.mInternalFileAttributes;
    }

    public void setInternalFileAttributes(int internalFileAttributes) {
        this.mInternalFileAttributes = internalFileAttributes;
    }

    public long getExternalFileAttributes() {
        return this.mExternalFileAttributes;
    }

    public void setExternalFileAttributes(long externalFileAttributes) {
        this.mExternalFileAttributes = externalFileAttributes;
    }

    public int getFilePermission() {
        return ((int)this.mExternalFileAttributes & 0x1FF0000) >> 16;
    }

    public String getFileName() {
        return this.mFileName;
    }

    public void setFileName(String fileName) {
        this.mFileName = fileName;
    }

    public int getFileNameLength() {
        return this.mFileNameLength;
    }

    public void setFileNameLength(int fileNameLength) {
        this.mFileNameLength = fileNameLength;
    }

    public int getExtraFieldLength() {
        return this.mExtraFieldLength;
    }

    public void setExtraFieldLength(int extraFieldLength) {
        this.mExtraFieldLength = extraFieldLength;
    }

    public int getFileCommentLength() {
        return this.mFileCommentLength;
    }

    public void setFileCommentLength(int fileCommentLength) {
        this.mFileCommentLength = fileCommentLength;
    }

    public int getInfoSize() {
        return 46 + this.mFileNameLength + this.mExtraFieldLength + this.mFileCommentLength;
    }

    @VisibleForTesting
    protected CentralDirectoryInfo() {
    }

    public CentralDirectoryInfo(byte[] data, int startOffset) throws IOException {
        this(data, startOffset, false);
    }

    public CentralDirectoryInfo(byte[] data, int startOffset, boolean useZip64) throws IOException {
        if (!Arrays.equals(CENTRAL_DIRECTORY_SIGNATURE, Arrays.copyOfRange(data, startOffset, startOffset + 4))) {
            throw new IOException("Invalid central directory info for zip file is found.");
        }
        this.mCompressionMethod = ByteArrayUtil.getInt(data, startOffset + 10, 2);
        this.mCrc = ByteArrayUtil.getLong(data, startOffset + 16, 4);
        this.mCompressedSize = ByteArrayUtil.getLong(data, startOffset + 20, 4);
        this.mUncompressedSize = ByteArrayUtil.getLong(data, startOffset + 24, 4);
        this.mInternalFileAttributes = ByteArrayUtil.getInt(data, startOffset + 36, 2);
        this.mExternalFileAttributes = ByteArrayUtil.getLong(data, startOffset + 38, 4);
        this.mLocalHeaderOffset = ByteArrayUtil.getLong(data, startOffset + 42, 4);
        this.mFileNameLength = ByteArrayUtil.getInt(data, startOffset + 28, 2);
        this.mFileName = ByteArrayUtil.getString(data, startOffset + 46, this.mFileNameLength);
        this.mExtraFieldLength = ByteArrayUtil.getInt(data, startOffset + 30, 2);
        this.mFileCommentLength = ByteArrayUtil.getInt(data, startOffset + 32, 2);
        if (!useZip64) {
            return;
        }
        if (Long.toHexString(this.mUncompressedSize).equals("ffffffff") || Long.toHexString(this.mCompressedSize).equals("ffffffff") || Long.toHexString(this.mLocalHeaderOffset).equals("ffffffff")) {
            boolean hasZip64HeaderId = false;
            int currPos = startOffset + this.mFileNameLength + 46;
            int endPos = currPos + this.mExtraFieldLength;
            while (currPos + 4 <= endPos) {
                int headerId = ByteArrayUtil.getInt(data, currPos, 2);
                int size = ByteArrayUtil.getInt(data, currPos + 2, 2);
                if (headerId == 1) {
                    this.mUncompressedSize = ByteArrayUtil.getLong(data, currPos + 4, 8);
                    this.mCompressedSize = ByteArrayUtil.getLong(data, currPos + 12, 8);
                    this.mLocalHeaderOffset = ByteArrayUtil.getLong(data, currPos + 20, 8);
                    hasZip64HeaderId = true;
                    break;
                }
                currPos += 4 + size;
            }
            if (!hasZip64HeaderId) {
                throw new RuntimeException(String.format("Failed to find ZIP64 field id(0x0001) from the Central Directory Info for file: %s", this.mFileName));
            }
        }
    }

    public boolean equals(Object o) {
        return this.toString().equals(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return String.format("Compression Method: %d\nCrc: %d\nCompressed Size: %d\nUncompressed Size: %d\nLocal Header Offset: %d\nInternal File Attributes: %d\nExternal File Attributes: %d\nFile Name: %s\nFile Name Length: %d\nExtra Field Length: %d\nFile Comment Length: %d", this.mCompressionMethod, this.mCrc, this.mCompressedSize, this.mUncompressedSize, this.mLocalHeaderOffset, this.mInternalFileAttributes, this.mExternalFileAttributes, this.mFileName, this.mFileNameLength, this.mExtraFieldLength, this.mFileCommentLength);
    }
}

