/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.zip;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.ByteArrayUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;

public final class EndCentralDirectoryInfo {
    public static final int MAX_LOOKBACK = 65536;
    private static final byte[] END_CENTRAL_DIRECTORY_SIGNATURE = new byte[]{80, 75, 5, 6};
    private static final byte[] ZIP64_END_CENTRAL_DIRECTORY_SIGNATURE = new byte[]{80, 75, 6, 6};
    private static final int CENTRAL_DIRECTORY_MAGIC_LENGTH = 4;
    private long mEntryNumber;
    private long mCentralDirSize;
    private long mCentralDirOffset;

    public long getEntryNumber() {
        return this.mEntryNumber;
    }

    public long getCentralDirSize() {
        return this.mCentralDirSize;
    }

    public long getCentralDirOffset() {
        return this.mCentralDirOffset;
    }

    public EndCentralDirectoryInfo(File zipFile) throws IOException {
        this(zipFile, false);
    }

    public EndCentralDirectoryInfo(File zipFile, boolean useZip64) throws IOException {
        byte[] data = this.getEndCentralDirectoryInfo(zipFile, END_CENTRAL_DIRECTORY_SIGNATURE);
        this.mEntryNumber = ByteArrayUtil.getInt(data, 10, 2);
        this.mCentralDirSize = ByteArrayUtil.getLong(data, 12, 4);
        this.mCentralDirOffset = ByteArrayUtil.getLong(data, 16, 4);
        if (!useZip64) {
            if (this.mCentralDirOffset < 0L) {
                throw new IOException("Failed to get offset of EndCentralDirectoryInfo. Partial unzip doesn't support zip files larger than 4GB.");
            }
            return;
        }
        if (Long.toHexString(this.mEntryNumber).equals("ffff") || Long.toHexString(this.mCentralDirSize).equals("ffffffff") || Long.toHexString(this.mCentralDirOffset).equals("ffffffff")) {
            LogUtil.CLog.i("Values(total number of entries, central directory size, and the offset of startof central directory header) in EndCentralDirectoryInfo reach limitation, getting real data from the ZIP64EndCentralDirectoryInfo.");
            data = this.getEndCentralDirectoryInfo(zipFile, ZIP64_END_CENTRAL_DIRECTORY_SIGNATURE);
            this.mEntryNumber = ByteArrayUtil.getLong(data, 32, 8);
            this.mCentralDirSize = ByteArrayUtil.getLong(data, 40, 8);
            this.mCentralDirOffset = ByteArrayUtil.getLong(data, 48, 8);
        }
    }

    private byte[] getEndCentralDirectoryInfo(File zipFile, byte[] signature) throws IOException {
        try (FileInputStream stream = new FileInputStream(zipFile);){
            int offset;
            long size = stream.getChannel().size();
            if (size > 65536L) {
                stream.skip(size - 65536L);
                size = 65536L;
            }
            byte[] endCentralDir = new byte[(int)size];
            stream.read(endCentralDir);
            for (offset = (int)size - 4 - 1; offset >= 0 && !Arrays.equals(signature, Arrays.copyOfRange(endCentralDir, offset, offset + 4)); --offset) {
            }
            if (offset < 0) {
                throw new RuntimeException("Failed to find end central directory info for zip file: " + zipFile.getPath());
            }
            byte[] byArray = Arrays.copyOfRange(endCentralDir, offset, offset + 64);
            return byArray;
        }
    }
}

