/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.zip;

import com.android.tradefed.util.ByteArrayUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;

public final class LocalFileHeader {
    public static final int LOCAL_FILE_HEADER_SIZE = 30;
    private static final byte[] LOCAL_FILE_HEADER_SIGNATURE = new byte[]{80, 75, 3, 4};
    private int mCompressionMethod;
    private long mCrc;
    private long mCompressedSize;
    private long mUncompressedSize;
    private int mFileNameLength;
    private int mExtraFieldLength;

    public int getCompressionMethod() {
        return this.mCompressionMethod;
    }

    public long getCrc() {
        return this.mCrc;
    }

    public long getCompressedSize() {
        return this.mCompressedSize;
    }

    public long getUncompressedSize() {
        return this.mUncompressedSize;
    }

    public int getFileNameLength() {
        return this.mFileNameLength;
    }

    public int getExtraFieldLength() {
        return this.mExtraFieldLength;
    }

    public int getHeaderSize() {
        return 30 + this.mFileNameLength + this.mExtraFieldLength;
    }

    public LocalFileHeader(File partialZipFile) throws IOException {
        this(partialZipFile, 0L);
    }

    public LocalFileHeader(File partialZipFile, long startOffset) throws IOException {
        byte[] data;
        try (FileInputStream stream = new FileInputStream(partialZipFile);){
            stream.skip(startOffset);
            data = new byte[30];
            stream.read(data);
        }
        if (!Arrays.equals(LOCAL_FILE_HEADER_SIGNATURE, Arrays.copyOfRange(data, 0, 4))) {
            throw new IOException("Invalid local file header for zip file is found.");
        }
        this.mCompressionMethod = ByteArrayUtil.getInt(data, 8, 2);
        this.mCrc = ByteArrayUtil.getLong(data, 14, 4);
        this.mCompressedSize = ByteArrayUtil.getLong(data, 18, 2);
        this.mUncompressedSize = ByteArrayUtil.getLong(data, 22, 2);
        this.mFileNameLength = ByteArrayUtil.getInt(data, 26, 2);
        this.mExtraFieldLength = ByteArrayUtil.getInt(data, 28, 2);
    }
}

