/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.zip;

import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.util.zip.CentralDirectoryInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class MergedZipEntryCollection {
    public static final int MAX_GAP = 4096;
    public static final double MAX_GAP_PERCENTAGE = 0.15;
    public static final int HEADER_SIZE = 2078;
    private static final int MAX_SIZE_GROUPS = 20;
    private List<CentralDirectoryInfo> mZipEntries;

    public MergedZipEntryCollection(List<CentralDirectoryInfo> zipEntries) {
        this.mZipEntries = zipEntries;
    }

    public long getStartOffset() {
        return this.mZipEntries.get(0).getLocalHeaderOffset();
    }

    public long getEndOffset() {
        CentralDirectoryInfo lastEntry = this.mZipEntries.get(this.mZipEntries.size() - 1);
        return lastEntry.getLocalHeaderOffset() + (long)lastEntry.getCompressedSize() + 2078L;
    }

    public List<CentralDirectoryInfo> getZipEntries() {
        return this.mZipEntries;
    }

    public static List<MergedZipEntryCollection> createCollections(List<CentralDirectoryInfo> zipEntries) {
        if (zipEntries.size() == 0) {
            return new ArrayList<MergedZipEntryCollection>();
        }
        try (CloseableTraceScope ignored = new CloseableTraceScope("merge_collections");){
            List entries = zipEntries.stream().sorted(Comparator.comparing(CentralDirectoryInfo::getLocalHeaderOffset)).collect(Collectors.toList());
            long endOffset = -1L;
            long totalGap = 0L;
            ArrayList<MergedZipEntryCollection> collections = new ArrayList<MergedZipEntryCollection>();
            ArrayList<CentralDirectoryInfo> group = new ArrayList<CentralDirectoryInfo>();
            for (CentralDirectoryInfo entry : entries) {
                if (endOffset >= 0L) {
                    long newGap = entry.getLocalHeaderOffset() - endOffset + totalGap;
                    long totalSize = entry.getLocalHeaderOffset() + 2078L + (long)entry.getCompressedSize() - ((CentralDirectoryInfo)group.get(0)).getLocalHeaderOffset();
                    double gapPercentage = (double)newGap / (double)totalSize;
                    if (endOffset < entry.getLocalHeaderOffset() - 4096L && 0.15 < gapPercentage) {
                        collections.addAll(MergedZipEntryCollection.splitLargeGroups(group));
                        group = new ArrayList();
                        totalGap = 0L;
                    }
                }
                group.add(entry);
                if (group.size() > 1 && entry.getLocalHeaderOffset() > endOffset) {
                    totalGap += entry.getLocalHeaderOffset() - endOffset;
                }
                endOffset = entry.getLocalHeaderOffset() + 2078L + (long)entry.getCompressedSize();
            }
            collections.addAll(MergedZipEntryCollection.splitLargeGroups(group));
            ArrayList<MergedZipEntryCollection> arrayList = collections;
            return arrayList;
        }
    }

    private static List<MergedZipEntryCollection> splitLargeGroups(List<CentralDirectoryInfo> group) {
        ArrayList<MergedZipEntryCollection> collections = new ArrayList<MergedZipEntryCollection>();
        if (group.size() < 20) {
            collections.add(new MergedZipEntryCollection(group));
            return collections;
        }
        List<List<CentralDirectoryInfo>> subSets = Lists.partition(group, 20);
        for (List<CentralDirectoryInfo> set : subSets) {
            collections.add(new MergedZipEntryCollection(set));
        }
        return collections;
    }
}

