/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.google.common.base.Enums;
import java.util.Arrays;
import java.util.stream.Collectors;

public class HelpfulEnumConverter<T extends Enum<T>>
extends Converter<String, T> {
    private final Converter<String, T> delegate;
    private final Class<T> klass;

    public HelpfulEnumConverter(Class<T> klass) {
        this.klass = klass;
        this.delegate = CaseFormat.LOWER_UNDERSCORE.converterTo(CaseFormat.UPPER_UNDERSCORE).andThen(Enums.stringConverter(klass));
    }

    @Override
    protected T doForward(String value) {
        try {
            return (T)((Enum)this.delegate.convert(value));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Unknown %s value '%s'. Possible values are %s.", this.klass.getSimpleName(), value, Arrays.stream((Enum[])this.klass.getEnumConstants()).map(c -> "'" + c.name().toLowerCase() + "'").collect(Collectors.joining(", "))));
        }
    }

    @Override
    protected String doBackward(T anEnum) {
        return this.delegate.reverse().convert(anEnum);
    }
}

