/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.extensions.java6.auth.oauth2;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialStore;
import com.google.api.client.auth.oauth2.StoredCredential;
import com.google.api.client.extensions.java6.auth.oauth2.FilePersistedCredentials;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonGenerator;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Charsets;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.store.DataStore;
import com.google.api.client.util.store.FileDataStoreFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

@Deprecated
@Beta
public class FileCredentialStore
implements CredentialStore {
    private static final Logger LOGGER = Logger.getLogger(FileCredentialStore.class.getName());
    private final JsonFactory jsonFactory;
    private final Lock lock = new ReentrantLock();
    private FilePersistedCredentials credentials = new FilePersistedCredentials();
    private final File file;
    private static final boolean IS_WINDOWS = File.separatorChar == '\\';

    public FileCredentialStore(File file2, JsonFactory jsonFactory) throws IOException {
        this.file = Preconditions.checkNotNull(file2);
        this.jsonFactory = Preconditions.checkNotNull(jsonFactory);
        File parentDir = file2.getCanonicalFile().getParentFile();
        if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
            throw new IOException("unable to create parent directory: " + parentDir);
        }
        if (this.isSymbolicLink(file2)) {
            throw new IOException("unable to use a symbolic link: " + file2);
        }
        if (!file2.createNewFile()) {
            this.loadCredentials(file2);
        } else {
            if (!(file2.setReadable(false, false) && file2.setWritable(false, false) && file2.setExecutable(false, false))) {
                LOGGER.warning("unable to change file permissions for everybody: " + file2);
            }
            if (!file2.setReadable(true) || !file2.setWritable(true)) {
                throw new IOException("unable to set file permissions: " + file2);
            }
            this.save();
        }
    }

    protected boolean isSymbolicLink(File file2) throws IOException {
        if (IS_WINDOWS) {
            return false;
        }
        File canonical = file2;
        if (file2.getParent() != null) {
            canonical = new File(file2.getParentFile().getCanonicalFile(), file2.getName());
        }
        return !canonical.getCanonicalFile().equals(canonical.getAbsoluteFile());
    }

    @Override
    public void store(String userId, Credential credential) throws IOException {
        this.lock.lock();
        try {
            this.credentials.store(userId, credential);
            this.save();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void delete(String userId, Credential credential) throws IOException {
        this.lock.lock();
        try {
            this.credentials.delete(userId);
            this.save();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean load(String userId, Credential credential) {
        this.lock.lock();
        try {
            boolean bl = this.credentials.load(userId, credential);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void loadCredentials(File file2) throws IOException {
        try (FileInputStream is = new FileInputStream(file2);){
            this.credentials = this.jsonFactory.fromInputStream(is, FilePersistedCredentials.class);
        }
    }

    private void save() throws IOException {
        try (FileOutputStream fos = new FileOutputStream(this.file);){
            JsonGenerator generator = this.jsonFactory.createJsonGenerator(fos, Charsets.UTF_8);
            generator.serialize(this.credentials);
            generator.close();
        }
    }

    public final void migrateTo(FileDataStoreFactory dataStoreFactory) throws IOException {
        this.migrateTo(StoredCredential.getDefaultDataStore(dataStoreFactory));
    }

    public final void migrateTo(DataStore<StoredCredential> credentialDataStore) throws IOException {
        this.credentials.migrateTo(credentialDataStore);
    }
}

