/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtCompatible;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

@GwtCompatible
public final class MinimalIterable<E>
implements Iterable<E> {
    private Iterator<E> iterator;

    public static <E> MinimalIterable<E> of(E ... elements) {
        return new MinimalIterable<E>(Arrays.asList(elements).iterator());
    }

    public static <E> MinimalIterable<E> from(Collection<E> elements) {
        return MinimalIterable.of(elements.toArray());
    }

    private MinimalIterable(Iterator<E> iterator2) {
        this.iterator = iterator2;
    }

    @Override
    public Iterator<E> iterator() {
        if (this.iterator == null) {
            throw new IllegalStateException();
        }
        try {
            Iterator<E> iterator2 = this.iterator;
            return iterator2;
        }
        finally {
            this.iterator = null;
        }
    }
}

