/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.MapInterfaceTest;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;

@GwtCompatible
public abstract class SortedMapInterfaceTest<K, V>
extends MapInterfaceTest<K, V> {
    protected SortedMapInterfaceTest(boolean allowsNullKeys, boolean allowsNullValues, boolean supportsPut, boolean supportsRemove, boolean supportsClear) {
        super(allowsNullKeys, allowsNullValues, supportsPut, supportsRemove, supportsClear);
    }

    @Override
    protected abstract SortedMap<K, V> makeEmptyMap() throws UnsupportedOperationException;

    @Override
    protected abstract SortedMap<K, V> makePopulatedMap() throws UnsupportedOperationException;

    @Override
    protected SortedMap<K, V> makeEitherMap() {
        try {
            return this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return this.makeEmptyMap();
        }
    }

    public void testTailMapWriteThrough() {
        Map map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        if (map.size() < 2 || !this.supportsPut) {
            return;
        }
        Iterator iterator2 = map.entrySet().iterator();
        Map.Entry firstEntry = iterator2.next();
        Map.Entry secondEntry = iterator2.next();
        Object key = secondEntry.getKey();
        SortedMap subMap = map.tailMap(key);
        Object value = this.getValueNotInPopulatedMap();
        subMap.put(key, value);
        SortedMapInterfaceTest.assertEquals(secondEntry.getValue(), value);
        SortedMapInterfaceTest.assertEquals(map.get(key), value);
        try {
            subMap.put(firstEntry.getKey(), value);
            SortedMapInterfaceTest.fail("Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testTailMapRemoveThrough() {
        Map map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        int oldSize = map.size();
        if (map.size() < 2 || !this.supportsRemove) {
            return;
        }
        Iterator iterator2 = map.entrySet().iterator();
        Map.Entry firstEntry = iterator2.next();
        Map.Entry secondEntry = iterator2.next();
        Object key = secondEntry.getKey();
        SortedMap subMap = map.tailMap(key);
        subMap.remove(key);
        SortedMapInterfaceTest.assertNull(subMap.remove(firstEntry.getKey()));
        SortedMapInterfaceTest.assertEquals(map.size(), oldSize - 1);
        SortedMapInterfaceTest.assertFalse(map.containsKey(key));
        SortedMapInterfaceTest.assertEquals(subMap.size(), oldSize - 2);
    }

    public void testTailMapClearThrough() {
        Map map;
        try {
            map = this.makePopulatedMap();
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        int oldSize = map.size();
        if (map.size() < 2 || !this.supportsClear) {
            return;
        }
        Iterator iterator2 = map.entrySet().iterator();
        iterator2.next();
        Map.Entry secondEntry = iterator2.next();
        Object key = secondEntry.getKey();
        SortedMap subMap = map.tailMap(key);
        int subMapSize = subMap.size();
        subMap.clear();
        SortedMapInterfaceTest.assertEquals(map.size(), oldSize - subMapSize);
        SortedMapInterfaceTest.assertTrue(subMap.isEmpty());
    }
}

