/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractListMultimapTester;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class ListMultimapRemoveTester<K, V>
extends AbstractListMultimapTester<K, V> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testMultimapRemoveDeletesFirstOccurrence() {
        this.resetContainer(Helpers.mapEntry(this.k0(), this.v0()), Helpers.mapEntry(this.k0(), this.v1()), Helpers.mapEntry(this.k0(), this.v0()));
        Collection list2 = ((ListMultimap)this.multimap()).get(this.k0());
        ((ListMultimap)this.multimap()).remove(this.k0(), this.v0());
        Helpers.assertContentsInOrder(list2, this.v1(), this.v0());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testRemoveAtIndexFromGetPropagates() {
        List<Object> values2 = Arrays.asList(this.v0(), this.v1(), this.v0());
        for (int i = 0; i < 3; ++i) {
            this.resetContainer(Helpers.mapEntry(this.k0(), this.v0()), Helpers.mapEntry(this.k0(), this.v1()), Helpers.mapEntry(this.k0(), this.v0()));
            List<Object> expectedValues = Helpers.copyToList(values2);
            ((ListMultimap)this.multimap()).get(this.k0()).remove(i);
            expectedValues.remove(i);
            this.assertGet(this.k0(), expectedValues);
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testRemoveAtIndexFromAsMapPropagates() {
        List<Object> values2 = Arrays.asList(this.v0(), this.v1(), this.v0());
        for (int i = 0; i < 3; ++i) {
            this.resetContainer(Helpers.mapEntry(this.k0(), this.v0()), Helpers.mapEntry(this.k0(), this.v1()), Helpers.mapEntry(this.k0(), this.v0()));
            List<Object> expectedValues = Helpers.copyToList(values2);
            List asMapValue = (List)((ListMultimap)this.multimap()).asMap().get(this.k0());
            asMapValue.remove(i);
            expectedValues.remove(i);
            this.assertGet(this.k0(), expectedValues);
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testRemoveAtIndexFromAsMapEntrySetPropagates() {
        List<Object> values2 = Arrays.asList(this.v0(), this.v1(), this.v0());
        for (int i = 0; i < 3; ++i) {
            this.resetContainer(Helpers.mapEntry(this.k0(), this.v0()), Helpers.mapEntry(this.k0(), this.v1()), Helpers.mapEntry(this.k0(), this.v0()));
            List<Object> expectedValues = Helpers.copyToList(values2);
            Map.Entry asMapEntry = ((ListMultimap)this.multimap()).asMap().entrySet().iterator().next();
            List asMapValue = (List)asMapEntry.getValue();
            asMapValue.remove(i);
            expectedValues.remove(i);
            this.assertGet(this.k0(), expectedValues);
        }
    }
}

