/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class MultimapContainsKeyTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testContainsKeyYes() {
        MultimapContainsKeyTester.assertTrue(this.multimap().containsKey(this.k0()));
    }

    public void testContainsKeyNo() {
        MultimapContainsKeyTester.assertFalse(this.multimap().containsKey(this.k3()));
    }

    public void testContainsKeysFromKeySet() {
        for (Object k : this.multimap().keySet()) {
            MultimapContainsKeyTester.assertTrue(this.multimap().containsKey(k));
        }
    }

    public void testContainsKeyAgreesWithGet() {
        for (Object k : this.sampleKeys()) {
            MultimapContainsKeyTester.assertEquals(!this.multimap().get(k).isEmpty(), this.multimap().containsKey(k));
        }
    }

    public void testContainsKeyAgreesWithAsMap() {
        for (Object k : this.sampleKeys()) {
            MultimapContainsKeyTester.assertEquals(this.multimap().containsKey(k), this.multimap().asMap().containsKey(k));
        }
    }

    public void testContainsKeyAgreesWithKeySet() {
        for (Object k : this.sampleKeys()) {
            MultimapContainsKeyTester.assertEquals(this.multimap().containsKey(k), this.multimap().keySet().contains(k));
        }
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testContainsKeyNullPresent() {
        this.initMultimapWithNullKey();
        MultimapContainsKeyTester.assertTrue(this.multimap().containsKey(null));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEY_QUERIES})
    public void testContainsKeyNullAbsent() {
        MultimapContainsKeyTester.assertFalse(this.multimap().containsKey(null));
    }

    @MapFeature.Require(absent={MapFeature.ALLOWS_NULL_KEY_QUERIES})
    public void testContainsKeyNullDisallowed() {
        try {
            this.multimap().containsKey(null);
            MultimapContainsKeyTester.fail("Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

