/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import java.util.Collection;
import java.util.Collections;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class MultimapGetTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    public void testGetEmpty() {
        Collection result = this.multimap().get(this.k3());
        Helpers.assertEmpty(result);
        MultimapGetTester.assertEquals(0, result.size());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testGetNonEmpty() {
        Collection result = this.multimap().get(this.k0());
        MultimapGetTester.assertFalse(result.isEmpty());
        Helpers.assertContentsAnyOrder(result, this.v0());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testGetMultiple() {
        this.resetContainer(Helpers.mapEntry(this.k0(), this.v0()), Helpers.mapEntry(this.k0(), this.v1()), Helpers.mapEntry(this.k0(), this.v2()));
        this.assertGet(this.k0(), this.v0(), this.v1(), this.v2());
    }

    public void testGetAbsentKey() {
        this.assertGet(this.k4(), new Object[0]);
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testPropagatesRemoveToMultimap() {
        this.resetContainer(Helpers.mapEntry(this.k0(), this.v0()), Helpers.mapEntry(this.k0(), this.v3()), Helpers.mapEntry(this.k0(), this.v2()));
        Collection result = this.multimap().get(this.k0());
        MultimapGetTester.assertTrue(result.remove(this.v0()));
        MultimapGetTester.assertFalse(this.multimap().containsEntry(this.k0(), this.v0()));
        MultimapGetTester.assertEquals(2, this.multimap().size());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testPropagatesRemoveLastElementToMultimap() {
        Collection result = this.multimap().get(this.k0());
        MultimapGetTester.assertTrue(result.remove(this.v0()));
        this.assertGet(this.k0(), new Object[0]);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPropagatesAddToMultimap() {
        Collection result = this.multimap().get(this.k0());
        MultimapGetTester.assertTrue(result.add(this.v3()));
        MultimapGetTester.assertTrue(this.multimap().containsKey(this.k0()));
        MultimapGetTester.assertEquals(this.getNumElements() + 1, this.multimap().size());
        MultimapGetTester.assertTrue(this.multimap().containsEntry(this.k0(), this.v3()));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPropagatesAddAllToMultimap() {
        Collection result = this.multimap().get(this.k0());
        MultimapGetTester.assertTrue(result.addAll(Collections.singletonList(this.v3())));
        MultimapGetTester.assertTrue(this.multimap().containsKey(this.k0()));
        MultimapGetTester.assertEquals(this.getNumElements() + 1, this.multimap().size());
        MultimapGetTester.assertTrue(this.multimap().containsEntry(this.k0(), this.v3()));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE, MapFeature.SUPPORTS_PUT})
    public void testPropagatesRemoveLastThenAddToMultimap() {
        int oldSize = this.getNumElements();
        Collection result = this.multimap().get(this.k0());
        MultimapGetTester.assertTrue(result.remove(this.v0()));
        MultimapGetTester.assertFalse(this.multimap().containsKey(this.k0()));
        MultimapGetTester.assertFalse(this.multimap().containsEntry(this.k0(), this.v0()));
        Helpers.assertEmpty(result);
        MultimapGetTester.assertTrue(result.add(this.v1()));
        MultimapGetTester.assertTrue(result.add(this.v2()));
        Helpers.assertContentsAnyOrder(result, this.v1(), this.v2());
        Helpers.assertContentsAnyOrder(this.multimap().get(this.k0()), this.v1(), this.v2());
        MultimapGetTester.assertTrue(this.multimap().containsKey(this.k0()));
        MultimapGetTester.assertFalse(this.multimap().containsEntry(this.k0(), this.v0()));
        MultimapGetTester.assertTrue(this.multimap().containsEntry(this.k0(), this.v2()));
        MultimapGetTester.assertEquals(oldSize + 1, this.multimap().size());
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testGetNullPresent() {
        this.initMultimapWithNullKey();
        Helpers.assertContains(this.multimap().get(null), this.getValueForNullKey());
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEY_QUERIES})
    public void testGetNullAbsent() {
        Helpers.assertEmpty(this.multimap().get(null));
    }

    @MapFeature.Require(absent={MapFeature.ALLOWS_NULL_KEY_QUERIES})
    public void testGetNullForbidden() {
        try {
            this.multimap().get(null);
            MultimapGetTester.fail("Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testGetWithNullValue() {
        this.initMultimapWithNullValue();
        Helpers.assertContains(this.multimap().get(this.getKeyForNullValue()), null);
    }
}

