/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import java.util.Iterator;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class MultimapKeysTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testKeys() {
        this.resetContainer(Helpers.mapEntry(this.k0(), this.v0()), Helpers.mapEntry(this.k0(), this.v1()), Helpers.mapEntry(this.k1(), this.v0()));
        Multiset keys = this.multimap().keys();
        MultimapKeysTester.assertEquals(2, keys.count(this.k0()));
        MultimapKeysTester.assertEquals(1, keys.count(this.k1()));
        MultimapKeysTester.assertEquals(3, keys.size());
        Helpers.assertContainsAllOf(keys, this.k0(), this.k1());
        Helpers.assertContainsAllOf(keys.entrySet(), Multisets.immutableEntry(this.k0(), 2), Multisets.immutableEntry(this.k1(), 1));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEY_QUERIES})
    public void testKeysCountAbsentNullKey() {
        MultimapKeysTester.assertEquals(0, this.multimap().keys().count(null));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    public void testKeysWithNullKey() {
        this.resetContainer(Helpers.mapEntry(null, this.v0()), Helpers.mapEntry(null, this.v1()), Helpers.mapEntry(this.k1(), this.v0()));
        Multiset keys = this.multimap().keys();
        MultimapKeysTester.assertEquals(2, keys.count(null));
        MultimapKeysTester.assertEquals(1, keys.count(this.k1()));
        MultimapKeysTester.assertEquals(3, keys.size());
        Helpers.assertContainsAllOf(keys, null, this.k1());
        Helpers.assertContainsAllOf(keys.entrySet(), Multisets.immutableEntry(null, 2), Multisets.immutableEntry(this.k1(), 1));
    }

    public void testKeysElementSet() {
        MultimapKeysTester.assertEquals(this.multimap().keySet(), this.multimap().keys().elementSet());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testKeysRemove() {
        int original = this.multimap().keys().remove(this.k0(), 1);
        MultimapKeysTester.assertEquals(Math.max(original - 1, 0), this.multimap().get(this.k0()).size());
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    public void testKeysEntrySetIteratorRemove() {
        Multiset keys = this.multimap().keys();
        Iterator itr = keys.entrySet().iterator();
        MultimapKeysTester.assertEquals(Multisets.immutableEntry(this.k0(), 1), itr.next());
        itr.remove();
        MultimapKeysTester.assertTrue(this.multimap().isEmpty());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testKeysEntrySetRemove() {
        this.resetContainer(Helpers.mapEntry(this.k0(), this.v0()), Helpers.mapEntry(this.k0(), this.v1()), Helpers.mapEntry(this.k1(), this.v0()));
        MultimapKeysTester.assertTrue(this.multimap().keys().entrySet().remove(Multisets.immutableEntry(this.k0(), 2)));
        MultimapKeysTester.assertEquals(1, this.multimap().size());
        MultimapKeysTester.assertTrue(this.multimap().containsEntry(this.k1(), this.v0()));
    }
}

