/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class MultimapReplaceValuesTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_NULL_VALUES})
    public void testReplaceValuesWithNullValue() {
        List<Object> values2 = Arrays.asList(this.v0(), null, this.v3());
        this.multimap().replaceValues(this.k0(), values2);
        this.assertGet(this.k0(), values2);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_NULL_KEYS})
    public void testReplaceValuesWithNullKey() {
        List<Object> values2 = Arrays.asList(this.v0(), this.v2(), this.v3());
        this.multimap().replaceValues(null, values2);
        this.assertGet(null, values2);
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE})
    public void testReplaceEmptyValues() {
        int size = this.multimap().size();
        List<Object> values2 = Arrays.asList(this.v0(), this.v2(), this.v3());
        this.multimap().replaceValues(this.k3(), values2);
        this.assertGet(this.k3(), values2);
        MultimapReplaceValuesTester.assertEquals(size + values2.size(), this.multimap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE})
    public void testReplaceValuesWithEmpty() {
        int size = this.multimap().size();
        ArrayList oldValues = new ArrayList(this.multimap().get(this.k0()));
        List values2 = Collections.emptyList();
        MultimapReplaceValuesTester.assertEquals(oldValues, new ArrayList(this.multimap().replaceValues(this.k0(), values2)));
        this.assertGet(this.k0(), new Object[0]);
        MultimapReplaceValuesTester.assertEquals(size - oldValues.size(), this.multimap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE})
    public void testReplaceValuesWithDuplicates() {
        int size = this.multimap().size();
        ArrayList oldValues = new ArrayList(this.multimap().get(this.k0()));
        List<Object> values2 = Arrays.asList(this.v0(), this.v3(), this.v0());
        MultimapReplaceValuesTester.assertEquals(oldValues, new ArrayList<Object>(this.multimap().replaceValues(this.k0(), values2)));
        MultimapReplaceValuesTester.assertEquals(size - oldValues.size() + this.multimap().get(this.k0()).size(), this.multimap().size());
        MultimapReplaceValuesTester.assertTrue(this.multimap().get(this.k0()).containsAll(values2));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE})
    public void testReplaceNonEmptyValues() {
        List keys = Helpers.copyToList(this.multimap().keySet());
        List<Object> values2 = Arrays.asList(this.v0(), this.v2(), this.v3());
        for (Object k : keys) {
            this.resetContainer();
            int size = this.multimap().size();
            List oldKeyValues = Helpers.copyToList(this.multimap().get(k));
            this.multimap().replaceValues(k, values2);
            this.assertGet(k, values2);
            MultimapReplaceValuesTester.assertEquals(size + values2.size() - oldKeyValues.size(), this.multimap().size());
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE})
    public void testReplaceValuesPropagatesToGet() {
        Collection getCollection = this.multimap().get(this.k0());
        List<Object> values2 = Arrays.asList(this.v0(), this.v2(), this.v3());
        this.multimap().replaceValues(this.k0(), values2);
        Helpers.assertContentsAnyOrder(getCollection, this.v0(), this.v2(), this.v3());
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testReplaceValuesRemoveNotSupported() {
        List values2 = Collections.singletonList(this.v3());
        try {
            this.multimap().replaceValues(this.k0(), values2);
            MultimapReplaceValuesTester.fail("Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    public void testReplaceValuesPutNotSupported() {
        List values2 = Collections.singletonList(this.v3());
        try {
            this.multimap().replaceValues(this.k0(), values2);
            MultimapReplaceValuesTester.fail("Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

