/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import java.util.Map;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class MultimapSizeTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    public void testSize() {
        int expectedSize = this.getNumElements();
        Object multimap = this.multimap();
        MultimapSizeTester.assertEquals(expectedSize, multimap.size());
        int size = 0;
        for (Map.Entry entry : multimap.entries()) {
            MultimapSizeTester.assertTrue(multimap.containsEntry(entry.getKey(), entry.getValue()));
            ++size;
        }
        MultimapSizeTester.assertEquals(expectedSize, size);
        int size2 = 0;
        for (Map.Entry entry2 : multimap.asMap().entrySet()) {
            size2 += entry2.getValue().size();
        }
        MultimapSizeTester.assertEquals(expectedSize, size2);
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testIsEmptyYes() {
        MultimapSizeTester.assertTrue(this.multimap().isEmpty());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testIsEmptyNo() {
        MultimapSizeTester.assertFalse(this.multimap().isEmpty());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    public void testSizeNullKey() {
        this.initMultimapWithNullKey();
        MultimapSizeTester.assertEquals(this.getNumElements(), this.multimap().size());
        MultimapSizeTester.assertFalse(this.multimap().isEmpty());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_VALUES})
    public void testSizeNullValue() {
        this.initMultimapWithNullValue();
        MultimapSizeTester.assertEquals(this.getNumElements(), this.multimap().size());
        MultimapSizeTester.assertFalse(this.multimap().isEmpty());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES})
    public void testSizeNullKeyAndValue() {
        this.initMultimapWithNullKeyAndValue();
        MultimapSizeTester.assertEquals(this.getNumElements(), this.multimap().size());
        MultimapSizeTester.assertFalse(this.multimap().isEmpty());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testSizeMultipleValues() {
        this.resetContainer(Helpers.mapEntry(this.k0(), this.v0()), Helpers.mapEntry(this.k0(), this.v1()), Helpers.mapEntry(this.k0(), this.v2()));
        MultimapSizeTester.assertEquals(3, this.multimap().size());
        MultimapSizeTester.assertEquals(3, this.multimap().entries().size());
        MultimapSizeTester.assertEquals(3, this.multimap().keys().size());
        MultimapSizeTester.assertEquals(1, this.multimap().keySet().size());
        MultimapSizeTester.assertEquals(1, this.multimap().asMap().size());
    }
}

