/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class MultimapToStringTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    @CollectionSize.Require(value={CollectionSize.ZERO})
    @CollectionFeature.Require(absent={CollectionFeature.NON_STANDARD_TOSTRING})
    public void testToStringEmpty() {
        MultimapToStringTester.assertEquals("{}", this.multimap().toString());
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    @CollectionFeature.Require(absent={CollectionFeature.NON_STANDARD_TOSTRING})
    public void testToStringSingleton() {
        MultimapToStringTester.assertEquals("{" + this.k0() + "=[" + this.v0() + "]}", this.multimap().toString());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(absent={CollectionFeature.NON_STANDARD_TOSTRING})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    public void testToStringWithNullKey() {
        this.initMultimapWithNullKey();
        this.testToStringMatchesAsMap();
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(absent={CollectionFeature.NON_STANDARD_TOSTRING})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_VALUES})
    public void testToStringWithNullValue() {
        this.initMultimapWithNullValue();
        this.testToStringMatchesAsMap();
    }

    @CollectionFeature.Require(absent={CollectionFeature.NON_STANDARD_TOSTRING})
    public void testToStringMatchesAsMap() {
        MultimapToStringTester.assertEquals(this.multimap().asMap().toString(), this.multimap().toString());
    }
}

