/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.google.AbstractMultisetTester;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class MultisetAddTester<E>
extends AbstractMultisetTester<E> {
    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_ADD})
    public void testAddUnsupported() {
        try {
            this.getMultiset().add(this.e0());
            MultisetAddTester.fail("Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddMeansAddOne() {
        int originalCount = this.getMultiset().count(this.e0());
        MultisetAddTester.assertTrue(this.getMultiset().add(this.e0()));
        MultisetAddTester.assertEquals(originalCount + 1, this.getMultiset().count(this.e0()));
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddOccurrencesZero() {
        int originalCount = this.getMultiset().count(this.e0());
        MultisetAddTester.assertEquals("old count", originalCount, this.getMultiset().add(this.e0(), 0));
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddOccurrences() {
        int originalCount = this.getMultiset().count(this.e0());
        MultisetAddTester.assertEquals("old count", originalCount, this.getMultiset().add(this.e0(), 2));
        MultisetAddTester.assertEquals("old count", originalCount + 2, this.getMultiset().count(this.e0()));
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddSeveralTimes() {
        int originalCount = this.getMultiset().count(this.e0());
        MultisetAddTester.assertEquals(originalCount, this.getMultiset().add(this.e0(), 2));
        MultisetAddTester.assertTrue(this.getMultiset().add(this.e0()));
        MultisetAddTester.assertEquals(originalCount + 3, this.getMultiset().add(this.e0(), 1));
        MultisetAddTester.assertEquals(originalCount + 4, this.getMultiset().count(this.e0()));
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_ADD})
    public void testAddOccurrences_unsupported() {
        try {
            this.getMultiset().add(this.e0(), 2);
            MultisetAddTester.fail("unsupported multiset.add(E, int) didn't throw exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddOccurrencesNegative() {
        try {
            this.getMultiset().add(this.e0(), -1);
            MultisetAddTester.fail("multiset.add(E, -1) didn't throw an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddTooMany() {
        this.getMultiset().add(this.e3(), Integer.MAX_VALUE);
        try {
            this.getMultiset().add(this.e3());
            MultisetAddTester.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        MultisetAddTester.assertEquals(Integer.MAX_VALUE, this.getMultiset().count(this.e3()));
        MultisetAddTester.assertEquals(Integer.MAX_VALUE, this.getMultiset().size());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddAll_emptySet() {
        MultisetAddTester.assertFalse(this.getMultiset().addAll(Collections.emptySet()));
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddAll_emptyMultiset() {
        MultisetAddTester.assertFalse(this.getMultiset().addAll((Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(new Object[0])));
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddAll_nonEmptyList() {
        MultisetAddTester.assertTrue(this.getMultiset().addAll(Arrays.asList(this.e3(), this.e4(), this.e3())));
        this.expectAdded(this.e3(), this.e4(), this.e3());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddAll_nonEmptyMultiset() {
        MultisetAddTester.assertTrue(this.getMultiset().addAll((Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(this.e3(), this.e4(), this.e3())));
        this.expectAdded(this.e3(), this.e4(), this.e3());
    }
}

