/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.WrongType;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.google.AbstractMultisetTester;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Ignore;

@Ignore
@GwtCompatible(emulated=true)
public class MultisetRemoveTester<E>
extends AbstractMultisetTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemoveNegative() {
        try {
            this.getMultiset().remove(this.e0(), -1);
            MultisetRemoveTester.fail("Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemoveUnsupported() {
        try {
            this.getMultiset().remove(this.e0(), 2);
            MultisetRemoveTester.fail("Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemoveZeroNoOp() {
        int originalCount = this.getMultiset().count(this.e0());
        MultisetRemoveTester.assertEquals("old count", originalCount, this.getMultiset().remove(this.e0(), 0));
        this.expectUnchanged();
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemove_occurrences_present() {
        MultisetRemoveTester.assertEquals("multiset.remove(present, 2) didn't return the old count", 1, this.getMultiset().remove(this.e0(), 2));
        MultisetRemoveTester.assertFalse("multiset contains present after multiset.remove(present, 2)", this.getMultiset().contains(this.e0()));
        MultisetRemoveTester.assertEquals(0, this.getMultiset().count(this.e0()));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemove_some_occurrences_present() {
        this.initThreeCopies();
        MultisetRemoveTester.assertEquals("multiset.remove(present, 2) didn't return the old count", 3, this.getMultiset().remove(this.e0(), 2));
        MultisetRemoveTester.assertTrue("multiset contains present after multiset.remove(present, 2)", this.getMultiset().contains(this.e0()));
        MultisetRemoveTester.assertEquals(1, this.getMultiset().count(this.e0()));
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemove_occurrences_absent() {
        int distinct = this.getMultiset().elementSet().size();
        MultisetRemoveTester.assertEquals("multiset.remove(absent, 0) didn't return 0", 0, this.getMultiset().remove(this.e3(), 2));
        MultisetRemoveTester.assertEquals(distinct, this.getMultiset().elementSet().size());
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemove_occurrences_unsupported_absent() {
        try {
            MultisetRemoveTester.assertEquals("multiset.remove(absent, 2) didn't return 0 or throw an exception", 0, this.getMultiset().remove(this.e3(), 2));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemove_occurrences_0() {
        int oldCount = this.getMultiset().count(this.e0());
        MultisetRemoveTester.assertEquals("multiset.remove(E, 0) didn't return the old count", oldCount, this.getMultiset().remove(this.e0(), 0));
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemove_occurrences_negative() {
        try {
            this.getMultiset().remove(this.e0(), -1);
            MultisetRemoveTester.fail("multiset.remove(E, -1) didn't throw an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemove_occurrences_wrongType() {
        MultisetRemoveTester.assertEquals("multiset.remove(wrongType, 1) didn't return 0", 0, this.getMultiset().remove((Object)WrongType.VALUE, 1));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.ALLOWS_NULL_VALUES})
    public void testRemove_nullPresent() {
        this.initCollectionWithNullElement();
        MultisetRemoveTester.assertEquals(1, this.getMultiset().remove(null, 2));
        MultisetRemoveTester.assertFalse("multiset contains present after multiset.remove(present, 2)", this.getMultiset().contains(null));
        MultisetRemoveTester.assertEquals(0, this.getMultiset().count(null));
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.ALLOWS_NULL_QUERIES})
    public void testRemove_nullAbsent() {
        MultisetRemoveTester.assertEquals(0, this.getMultiset().remove(null, 2));
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE}, absent={CollectionFeature.ALLOWS_NULL_QUERIES})
    public void testRemove_nullForbidden() {
        try {
            this.getMultiset().remove(null, 2);
            MultisetRemoveTester.fail("Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemoveAllIgnoresCount() {
        this.initThreeCopies();
        MultisetRemoveTester.assertTrue(this.getMultiset().removeAll(Collections.singleton(this.e0())));
        Helpers.assertEmpty(this.getMultiset());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRetainAllIgnoresCount() {
        this.initThreeCopies();
        List contents = Helpers.copyToList(this.getMultiset());
        MultisetRemoveTester.assertFalse(this.getMultiset().retainAll(Collections.singleton(this.e0())));
        this.expectContents(contents);
    }

    @GwtIncompatible
    public static List<Method> getRemoveDuplicateInitializingMethods() {
        return Arrays.asList(Helpers.getMethod(MultisetRemoveTester.class, "testRemove_some_occurrences_present"));
    }
}

