/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.google.AbstractMultisetSetCountTester;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collections;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class MultisetSetCountConditionallyTester<E>
extends AbstractMultisetSetCountTester<E> {
    @Override
    void setCountCheckReturnValue(E element, int count) {
        MultisetSetCountConditionallyTester.assertTrue("setCount() with the correct expected present count should return true", this.setCount(element, count));
    }

    @Override
    void setCountNoCheckReturnValue(E element, int count) {
        this.setCount(element, count);
    }

    @CanIgnoreReturnValue
    private boolean setCount(E element, int count) {
        return this.getMultiset().setCount(element, this.getMultiset().count(element), count);
    }

    private void assertSetCountNegativeOldCount() {
        try {
            this.getMultiset().setCount(this.e3(), -1, 1);
            MultisetSetCountConditionallyTester.fail("calling setCount() with a negative oldCount should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testSetCountConditional_negativeOldCount_addSupported() {
        this.assertSetCountNegativeOldCount();
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_ADD})
    public void testSetCountConditional_negativeOldCount_addUnsupported() {
        try {
            this.assertSetCountNegativeOldCount();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testSetCountConditional_oldCountTooLarge() {
        MultisetSetCountConditionallyTester.assertFalse("setCount() with a too-large oldCount should return false", this.getMultiset().setCount(this.e0(), 2, 3));
        this.expectUnchanged();
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testSetCountConditional_oldCountTooSmallZero() {
        MultisetSetCountConditionallyTester.assertFalse("setCount() with a too-small oldCount should return false", this.getMultiset().setCount(this.e0(), 0, 2));
        this.expectUnchanged();
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testSetCountConditional_oldCountTooSmallNonzero() {
        this.initThreeCopies();
        MultisetSetCountConditionallyTester.assertFalse("setCount() with a too-small oldCount should return false", this.getMultiset().setCount(this.e0(), 1, 5));
        this.expectContents(Collections.nCopies(3, this.e0()));
    }
}

