/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.collect.testing.TestCollectionGenerator;
import com.google.common.collect.testing.TestCollidingSetGenerator;
import com.google.common.collect.testing.TestIntegerSortedSetGenerator;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.TestStringListGenerator;
import com.google.common.collect.testing.TestStringSetGenerator;
import com.google.common.collect.testing.TestStringSortedSetGenerator;
import com.google.common.collect.testing.TestUnhashableCollectionGenerator;
import com.google.common.collect.testing.UnhashableObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import junit.framework.Assert;

@GwtCompatible(emulated=true)
public class SetGenerators {
    private static Ordering<String> createExplicitComparator(String[] elements) {
        LinkedHashSet<String> elementsPlus = Sets.newLinkedHashSet();
        elementsPlus.add("\u0000");
        elementsPlus.add("\u0000\u0000");
        elementsPlus.addAll(Arrays.asList(elements));
        elementsPlus.add("z");
        elementsPlus.add("zz");
        return Ordering.explicit(Lists.newArrayList(elementsPlus));
    }

    private static <E extends Comparable<? super E>> SortedSet<E> nullCheckedTreeSet(E[] elements) {
        TreeSet<Comparable> set = Sets.newTreeSet();
        for (E element : elements) {
            set.add((Comparable)Preconditions.checkNotNull(element));
        }
        return set;
    }

    private static abstract class AbstractContiguousSetGenerator
    extends TestIntegerSortedSetGenerator {
        private AbstractContiguousSetGenerator() {
        }

        protected final ContiguousSet<Integer> checkedCreate(SortedSet<Integer> elementsSet) {
            ArrayList<Integer> elements = Lists.newArrayList(elementsSet);
            for (int i = 0; i < elements.size() - 1; ++i) {
                Assert.assertEquals((Integer)elements.get(i) + 1, (Integer)elements.get(i + 1));
            }
            Range<Integer> range = elements.isEmpty() ? Range.closedOpen(0, 0) : Range.encloseAll(elements);
            return ContiguousSet.create(range, DiscreteDomain.integers());
        }
    }

    @GwtIncompatible
    public static class ContiguousSetDescendingGenerator
    extends AbstractContiguousSetGenerator {
        @Override
        protected SortedSet<Integer> create(Integer[] elements) {
            return this.checkedCreate(SetGenerators.nullCheckedTreeSet((Comparable[])elements)).descendingSet();
        }

        @Override
        public List<Integer> order(List<Integer> insertionOrder) {
            Collections.sort(insertionOrder, Ordering.natural().reverse());
            return insertionOrder;
        }
    }

    public static class ContiguousSetSubsetGenerator
    extends AbstractContiguousSetGenerator {
        @Override
        protected SortedSet<Integer> create(Integer[] elements) {
            SortedSet set = SetGenerators.nullCheckedTreeSet((Comparable[])elements);
            if (set.isEmpty()) {
                return ContiguousSet.create(Range.openClosed(0, 1), DiscreteDomain.integers()).subSet(0, 1);
            }
            int tooHigh = (Integer)set.last() + 1;
            int tooLow = (Integer)set.first() - 1;
            set.add(tooHigh);
            set.add(tooLow);
            return this.checkedCreate(set).subSet(tooLow + 1, tooHigh);
        }
    }

    public static class ContiguousSetTailsetGenerator
    extends AbstractContiguousSetGenerator {
        @Override
        protected SortedSet<Integer> create(Integer[] elements) {
            SortedSet set = SetGenerators.nullCheckedTreeSet((Comparable[])elements);
            int tooLow = set.isEmpty() ? 0 : (Integer)set.first() - 1;
            set.add(tooLow);
            return this.checkedCreate(set).tailSet(tooLow + 1);
        }
    }

    public static class ContiguousSetHeadsetGenerator
    extends AbstractContiguousSetGenerator {
        @Override
        protected SortedSet<Integer> create(Integer[] elements) {
            SortedSet set = SetGenerators.nullCheckedTreeSet((Comparable[])elements);
            int tooHigh = set.isEmpty() ? 0 : (Integer)set.last() + 1;
            set.add(tooHigh);
            return this.checkedCreate(set).headSet(tooHigh);
        }
    }

    public static class ContiguousSetGenerator
    extends AbstractContiguousSetGenerator {
        @Override
        protected SortedSet<Integer> create(Integer[] elements) {
            return this.checkedCreate(SetGenerators.nullCheckedTreeSet((Comparable[])elements));
        }
    }

    public static abstract class TestUnhashableSetGenerator
    extends TestUnhashableCollectionGenerator<Set<UnhashableObject>>
    implements TestSetGenerator<UnhashableObject> {
    }

    public static class ImmutableSortedSetSubsetAsListSubListGenerator
    extends TestStringListGenerator {
        @Override
        protected List<String> create(String[] elements) {
            Ordering comparator = SetGenerators.createExplicitComparator(elements);
            ImmutableSortedSet.Builder builder = ImmutableSortedSet.orderedBy(comparator);
            builder.add("\u0000");
            builder.add("\u0000\u0000");
            builder.add(elements);
            builder.add("z");
            builder.add("zz");
            return ((ImmutableSortedSet)((ImmutableSortedSet)builder.build()).subSet("\u0000\u0000", "zz")).asList().subList(1, elements.length + 1);
        }
    }

    public static class ImmutableSortedSetAsListSubListGenerator
    extends TestStringListGenerator {
        @Override
        protected List<String> create(String[] elements) {
            Ordering comparator = SetGenerators.createExplicitComparator(elements);
            ImmutableSortedSet.Builder builder = ImmutableSortedSet.orderedBy(comparator);
            builder.add("\u0000");
            builder.add(elements);
            builder.add("z");
            return ((ImmutableSortedSet)builder.build()).asList().subList(1, elements.length + 1);
        }
    }

    @GwtIncompatible
    public static class ImmutableSortedSetDescendingAsListGenerator
    extends TestStringListGenerator {
        @Override
        protected List<String> create(String[] elements) {
            Ordering comparator = SetGenerators.createExplicitComparator(elements).reverse();
            return ((ImmutableSortedSet)((ImmutableSortedSet)((ImmutableSortedSet.Builder)ImmutableSortedSet.orderedBy(comparator).add(elements)).build()).descendingSet()).asList();
        }
    }

    public static class ImmutableSortedSetSubsetAsListGenerator
    extends TestStringListGenerator {
        @Override
        protected List<String> create(String[] elements) {
            Ordering comparator = SetGenerators.createExplicitComparator(elements);
            ImmutableSortedSet.Builder builder = ImmutableSortedSet.orderedBy(comparator);
            builder.add("\u0000");
            builder.add(elements);
            builder.add("z");
            return ((ImmutableSortedSet)((ImmutableSortedSet)builder.build()).subSet("\u0000\u0000", "z")).asList();
        }
    }

    public static class ImmutableSortedSetAsListGenerator
    extends TestStringListGenerator {
        @Override
        protected List<String> create(String[] elements) {
            Ordering comparator = SetGenerators.createExplicitComparator(elements);
            ImmutableSortedSet<String> set = ImmutableSortedSet.copyOf(comparator, Arrays.asList(elements));
            return ((ImmutableCollection)set).asList();
        }
    }

    public static class ImmutableSetAsListGenerator
    extends TestStringListGenerator {
        @Override
        protected List<String> create(String[] elements) {
            return ImmutableSet.copyOf(elements).asList();
        }
    }

    public static class ImmutableSortedSetUnhashableGenerator
    extends TestUnhashableSetGenerator {
        @Override
        public Set<UnhashableObject> create(UnhashableObject[] elements) {
            return ImmutableSortedSet.copyOf((Comparable[])elements);
        }
    }

    public static class ImmutableSortedSetReversedOrderGenerator
    extends TestStringSetGenerator {
        protected SortedSet<String> create(String[] elements) {
            return ((ImmutableSortedSet.Builder)ImmutableSortedSet.reverseOrder().addAll(Arrays.asList(elements).iterator())).build();
        }

        @Override
        public List<String> order(List<String> insertionOrder) {
            Collections.sort(insertionOrder, Collections.reverseOrder());
            return insertionOrder;
        }
    }

    public static class ImmutableSortedSetExplicitSuperclassComparatorGenerator
    extends TestStringSetGenerator {
        private static final Comparator<Comparable<?>> COMPARABLE_REVERSED = Collections.reverseOrder();

        protected SortedSet<String> create(String[] elements) {
            return ((ImmutableSortedSet.Builder)new ImmutableSortedSet.Builder(COMPARABLE_REVERSED).add(elements)).build();
        }

        @Override
        public List<String> order(List<String> insertionOrder) {
            Collections.sort(insertionOrder, Collections.reverseOrder());
            return insertionOrder;
        }
    }

    public static class ImmutableSortedSetExplicitComparator
    extends TestStringSetGenerator {
        private static final Comparator<String> STRING_REVERSED = Collections.reverseOrder();

        protected SortedSet<String> create(String[] elements) {
            return ((ImmutableSortedSet.Builder)ImmutableSortedSet.orderedBy(STRING_REVERSED).add(elements)).build();
        }

        @Override
        public List<String> order(List<String> insertionOrder) {
            Collections.sort(insertionOrder, Collections.reverseOrder());
            return insertionOrder;
        }
    }

    @GwtIncompatible
    public static class ImmutableSortedSetDescendingGenerator
    extends TestStringSortedSetGenerator {
        @Override
        protected SortedSet<String> create(String[] elements) {
            return ((ImmutableSortedSet)((ImmutableSortedSet.Builder)ImmutableSortedSet.reverseOrder().add(elements)).build()).descendingSet();
        }
    }

    public static class ImmutableSortedSetSubsetGenerator
    extends TestStringSortedSetGenerator {
        @Override
        protected SortedSet<String> create(String[] elements) {
            ArrayList<String> list2 = Lists.newArrayList(elements);
            list2.add("\u0000");
            list2.add("zzz");
            return ImmutableSortedSet.copyOf(list2).subSet((Object)"\u0000\u0000", (Object)"zzy");
        }
    }

    public static class ImmutableSortedSetTailsetGenerator
    extends TestStringSortedSetGenerator {
        @Override
        protected SortedSet<String> create(String[] elements) {
            ArrayList<String> list2 = Lists.newArrayList(elements);
            list2.add("\u0000");
            return ImmutableSortedSet.copyOf(list2).tailSet((Object)"\u0000\u0000");
        }
    }

    public static class ImmutableSortedSetHeadsetGenerator
    extends TestStringSortedSetGenerator {
        @Override
        protected SortedSet<String> create(String[] elements) {
            ArrayList<String> list2 = Lists.newArrayList(elements);
            list2.add("zzz");
            return ImmutableSortedSet.copyOf(list2).headSet((Object)"zzy");
        }
    }

    public static class ImmutableSortedSetCopyOfGenerator
    extends TestStringSortedSetGenerator {
        @Override
        protected SortedSet<String> create(String[] elements) {
            return ImmutableSortedSet.copyOf((Comparable[])elements);
        }
    }

    public static class DegeneratedImmutableSetGenerator
    extends TestStringSetGenerator {
        @Override
        protected Set<String> create(String[] elements) {
            return ImmutableSet.of(elements[0], elements[0]);
        }
    }

    public static class ImmutableSetWithBadHashesGenerator
    extends TestCollidingSetGenerator
    implements TestCollectionGenerator<Object> {
        @Override
        public Set<Object> create(Object ... elements) {
            return ImmutableSet.copyOf(elements);
        }
    }

    public static class ImmutableSetTooSmallBuilderGenerator
    extends TestStringSetGenerator {
        @Override
        protected Set<String> create(String[] elements) {
            ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize(Math.max(0, Sets.newHashSet(elements).size() - 1));
            for (String e : elements) {
                builder.add(e);
            }
            return builder.build();
        }
    }

    public static class ImmutableSetTooBigBuilderGenerator
    extends TestStringSetGenerator {
        @Override
        protected Set<String> create(String[] elements) {
            ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize(Sets.newHashSet(elements).size() + 1);
            for (String e : elements) {
                builder.add(e);
            }
            return builder.build();
        }
    }

    public static class ImmutableSetSizedBuilderGenerator
    extends TestStringSetGenerator {
        @Override
        protected Set<String> create(String[] elements) {
            ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize(Sets.newHashSet(elements).size());
            for (String e : elements) {
                builder.add(e);
            }
            return builder.build();
        }
    }

    public static class ImmutableSetUnsizedBuilderGenerator
    extends TestStringSetGenerator {
        @Override
        protected Set<String> create(String[] elements) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (String e : elements) {
                builder.add(e);
            }
            return builder.build();
        }
    }

    public static class ImmutableSetCopyOfGenerator
    extends TestStringSetGenerator {
        @Override
        protected Set<String> create(String[] elements) {
            return ImmutableSet.copyOf(elements);
        }
    }
}

