/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.google.TestSetMultimapGenerator;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@GwtCompatible
public abstract class TestStringSetMultimapGenerator
implements TestSetMultimapGenerator<String, String> {
    @Override
    public SampleElements<Map.Entry<String, String>> samples() {
        return new SampleElements<Map.Entry<String, String>>(Helpers.mapEntry("one", "January"), Helpers.mapEntry("two", "February"), Helpers.mapEntry("three", "March"), Helpers.mapEntry("four", "April"), Helpers.mapEntry("five", "May"));
    }

    @Override
    public SampleElements<String> sampleKeys() {
        return new SampleElements<String>("one", "two", "three", "four", "five");
    }

    @Override
    public SampleElements<String> sampleValues() {
        return new SampleElements<String>("January", "February", "March", "April", "May");
    }

    @Override
    public Collection<String> createCollection(Iterable<? extends String> values2) {
        return Helpers.copyToSet(values2);
    }

    @Override
    public final SetMultimap<String, String> create(Object ... entries) {
        Map.Entry[] array = new Map.Entry[entries.length];
        int i = 0;
        for (Object o : entries) {
            Map.Entry e = (Map.Entry)o;
            array[i++] = e;
        }
        return this.create(array);
    }

    protected abstract SetMultimap<String, String> create(Map.Entry<String, String>[] var1);

    public final Map.Entry<String, String>[] createArray(int length) {
        return new Map.Entry[length];
    }

    public final String[] createKeyArray(int length) {
        return new String[length];
    }

    public final String[] createValueArray(int length) {
        return new String[length];
    }

    @Override
    public Iterable<Map.Entry<String, String>> order(List<Map.Entry<String, String>> insertionOrder) {
        return insertionOrder;
    }
}

