/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractCollectionTester;
import com.google.common.collect.testing.MinimalCollection;
import com.google.common.collect.testing.WrongType;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class CollectionContainsAllTester<E>
extends AbstractCollectionTester<E> {
    public void testContainsAll_empty() {
        CollectionContainsAllTester.assertTrue("containsAll(empty) should return true", this.collection.containsAll(MinimalCollection.of(new Object[0])));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testContainsAll_subset() {
        CollectionContainsAllTester.assertTrue("containsAll(subset) should return true", this.collection.containsAll(MinimalCollection.of(this.e0())));
    }

    public void testContainsAll_sameElements() {
        CollectionContainsAllTester.assertTrue("containsAll(sameElements) should return true", this.collection.containsAll(MinimalCollection.of(this.createSamplesArray())));
    }

    public void testContainsAll_self() {
        CollectionContainsAllTester.assertTrue("containsAll(this) should return true", this.collection.containsAll(this.collection));
    }

    public void testContainsAll_partialOverlap() {
        CollectionContainsAllTester.assertFalse("containsAll(partialOverlap) should return false", this.collection.containsAll(MinimalCollection.of(this.e0(), this.e3())));
    }

    public void testContainsAll_disjoint() {
        CollectionContainsAllTester.assertFalse("containsAll(disjoint) should return false", this.collection.containsAll(MinimalCollection.of(this.e3())));
    }

    @CollectionFeature.Require(absent={CollectionFeature.ALLOWS_NULL_QUERIES})
    public void testContainsAll_nullNotAllowed() {
        try {
            CollectionContainsAllTester.assertFalse(this.collection.containsAll(MinimalCollection.of(new Object[]{null})));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_QUERIES})
    public void testContainsAll_nullAllowed() {
        CollectionContainsAllTester.assertFalse(this.collection.containsAll(MinimalCollection.of(new Object[]{null})));
    }

    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testContainsAll_nullPresent() {
        this.initCollectionWithNullElement();
        CollectionContainsAllTester.assertTrue(this.collection.containsAll(MinimalCollection.of(new Object[]{null})));
    }

    public void testContainsAll_wrongType() {
        MinimalCollection<WrongType> wrong = MinimalCollection.of(WrongType.VALUE);
        try {
            CollectionContainsAllTester.assertFalse("containsAll(wrongType) should return false or throw", this.collection.containsAll(wrong));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }
}

