/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractCollectionTester;
import com.google.common.collect.testing.WrongType;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class CollectionContainsTester<E>
extends AbstractCollectionTester<E> {
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testContains_yes() {
        CollectionContainsTester.assertTrue("contains(present) should return true", this.collection.contains(this.e0()));
    }

    public void testContains_no() {
        CollectionContainsTester.assertFalse("contains(notPresent) should return false", this.collection.contains(this.e3()));
    }

    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_QUERIES})
    public void testContains_nullNotContainedButQueriesSupported() {
        CollectionContainsTester.assertFalse("contains(null) should return false", this.collection.contains(null));
    }

    @CollectionFeature.Require(absent={CollectionFeature.ALLOWS_NULL_QUERIES})
    public void testContains_nullNotContainedAndUnsupported() {
        this.expectNullMissingWhenNullUnsupported("contains(null) should return false or throw");
    }

    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testContains_nonNullWhenNullContained() {
        this.initCollectionWithNullElement();
        CollectionContainsTester.assertFalse("contains(notPresent) should return false", this.collection.contains(this.e3()));
    }

    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testContains_nullContained() {
        this.initCollectionWithNullElement();
        CollectionContainsTester.assertTrue("contains(null) should return true", this.collection.contains(null));
    }

    public void testContains_wrongType() {
        try {
            CollectionContainsTester.assertFalse("contains(wrongType) should return false or throw", this.collection.contains((Object)WrongType.VALUE));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }
}

