/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractCollectionTester;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.WrongType;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class CollectionRemoveTester<E>
extends AbstractCollectionTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemove_present() {
        int initialSize = this.collection.size();
        CollectionRemoveTester.assertTrue("remove(present) should return true", this.collection.remove(this.e0()));
        CollectionRemoveTester.assertEquals("remove(present) should decrease a collection's size by one.", initialSize - 1, this.collection.size());
        this.expectMissing(this.e0());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testRemovePresentConcurrentWithIteration() {
        try {
            Iterator iterator2 = this.collection.iterator();
            CollectionRemoveTester.assertTrue(this.collection.remove(this.e0()));
            iterator2.next();
            CollectionRemoveTester.fail("Expected ConcurrentModificationException");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemove_notPresent() {
        CollectionRemoveTester.assertFalse("remove(notPresent) should return false", this.collection.remove(this.e3()));
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemove_nullPresent() {
        this.collection = (Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(this.createArrayWithNullElement());
        int initialSize = this.collection.size();
        CollectionRemoveTester.assertTrue("remove(null) should return true", this.collection.remove(null));
        CollectionRemoveTester.assertEquals("remove(present) should decrease a collection's size by one.", initialSize - 1, this.collection.size());
        this.expectMissing(new Object[]{null});
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemove_unsupported() {
        try {
            this.collection.remove(this.e0());
            CollectionRemoveTester.fail("remove(present) should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
        CollectionRemoveTester.assertTrue("remove(present) should not remove the element", this.collection.contains(this.e0()));
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemove_unsupportedNotPresent() {
        try {
            CollectionRemoveTester.assertFalse("remove(notPresent) should return false or throw UnsupportedOperationException", this.collection.remove(this.e3()));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
        this.expectMissing(this.e3());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE}, absent={CollectionFeature.ALLOWS_NULL_QUERIES})
    public void testRemove_nullNotSupported() {
        try {
            CollectionRemoveTester.assertFalse("remove(null) should return false or throw NullPointerException", this.collection.remove(null));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.ALLOWS_NULL_QUERIES})
    public void testRemove_nullAllowed() {
        CollectionRemoveTester.assertFalse("remove(null) should return false", this.collection.remove(null));
        this.expectUnchanged();
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testIteratorRemove_unsupported() {
        Iterator iterator2 = this.collection.iterator();
        iterator2.next();
        try {
            iterator2.remove();
            CollectionRemoveTester.fail("iterator.remove() should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
        CollectionRemoveTester.assertTrue(this.collection.contains(this.e0()));
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testRemove_wrongType() {
        try {
            CollectionRemoveTester.assertFalse(this.collection.remove((Object)WrongType.VALUE));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.expectUnchanged();
    }
}

