/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import java.util.concurrent.ConcurrentMap;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class ConcurrentMapReplaceEntryTester<K, V>
extends AbstractMapTester<K, V> {
    @Override
    protected ConcurrentMap<K, V> getMap() {
        return (ConcurrentMap)super.getMap();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testReplaceEntry_supportedPresent() {
        ConcurrentMapReplaceEntryTester.assertTrue(this.getMap().replace(this.k0(), this.v0(), this.v3()));
        this.expectReplacement(this.entry(this.k0(), this.v3()));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testReplaceEntry_supportedPresentUnchanged() {
        ConcurrentMapReplaceEntryTester.assertTrue(this.getMap().replace(this.k0(), this.v0(), this.v0()));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testReplaceEntry_supportedWrongValue() {
        ConcurrentMapReplaceEntryTester.assertFalse(this.getMap().replace(this.k0(), this.v3(), this.v4()));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testReplaceEntry_supportedAbsentKey() {
        ConcurrentMapReplaceEntryTester.assertFalse(this.getMap().replace(this.k3(), this.v3(), this.v4()));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testReplaceEntry_presentNullValueUnsupported() {
        try {
            this.getMap().replace(this.k0(), this.v0(), null);
            ConcurrentMapReplaceEntryTester.fail("Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_VALUE_QUERIES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testReplaceEntry_wrongValueNullValueUnsupported() {
        try {
            ConcurrentMapReplaceEntryTester.assertFalse(this.getMap().replace(this.k0(), this.v3(), null));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_VALUE_QUERIES})
    public void testReplaceEntry_absentKeyNullValueUnsupported() {
        try {
            ConcurrentMapReplaceEntryTester.assertFalse(this.getMap().replace(this.k3(), this.v3(), null));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_VALUE_QUERIES})
    public void testReplaceEntry_nullDifferentFromAbsent() {
        ConcurrentMapReplaceEntryTester.assertFalse(this.getMap().replace(this.k3(), null, this.v3()));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_VALUE_QUERIES})
    public void testReplaceEntry_expectNullUnsupported() {
        try {
            ConcurrentMapReplaceEntryTester.assertFalse(this.getMap().replace(this.k3(), null, this.v3()));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testReplaceEntry_unsupportedPresent() {
        try {
            this.getMap().replace(this.k0(), this.v0(), this.v3());
            ConcurrentMapReplaceEntryTester.fail("Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testReplaceEntry_unsupportedWrongValue() {
        try {
            this.getMap().replace(this.k0(), this.v3(), this.v4());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    public void testReplaceEntry_unsupportedAbsentKey() {
        try {
            this.getMap().replace(this.k3(), this.v3(), this.v4());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }
}

