/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.ListFeature;
import com.google.common.collect.testing.testers.AbstractListTester;
import java.util.Collections;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class ListReplaceAllTester<E>
extends AbstractListTester<E> {
    @ListFeature.Require(value={ListFeature.SUPPORTS_SET})
    public void testReplaceAll() {
        this.getList().replaceAll(e -> this.samples.e3());
        this.expectContents(Collections.nCopies(this.getNumElements(), this.samples.e3()));
    }

    @ListFeature.Require(value={ListFeature.SUPPORTS_SET})
    public void testReplaceAll_changesSome() {
        this.getList().replaceAll(e -> e.equals(this.samples.e0()) ? this.samples.e3() : e);
        E[] expected = this.createSamplesArray();
        for (int i = 0; i < expected.length; ++i) {
            if (!expected[i].equals(this.samples.e0())) continue;
            expected[i] = this.samples.e3();
        }
        this.expectContents(expected);
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @ListFeature.Require(absent={ListFeature.SUPPORTS_SET})
    public void testReplaceAll_unsupported() {
        try {
            this.getList().replaceAll(e -> e);
            ListReplaceAllTester.fail("replaceAll() should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }
}

