/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import java.util.Map;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class MapComputeTester<K, V>
extends AbstractMapTester<K, V> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE})
    public void testCompute_absentToPresent() {
        MapComputeTester.assertEquals("Map.compute(absent, functionReturningValue) should return value", this.v3(), this.getMap().compute(this.k3(), (k, v) -> {
            MapComputeTester.assertEquals(this.k3(), k);
            MapComputeTester.assertNull(v);
            return this.v3();
        }));
        this.expectAdded((Map.Entry)this.e3());
        MapComputeTester.assertEquals(this.getNumElements() + 1, this.getMap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE})
    public void testCompute_absentToAbsent() {
        MapComputeTester.assertNull("Map.compute(absent, functionReturningNull) should return null", this.getMap().compute(this.k3(), (k, v) -> {
            MapComputeTester.assertEquals(this.k3(), k);
            MapComputeTester.assertNull(v);
            return null;
        }));
        this.expectUnchanged();
        MapComputeTester.assertEquals(this.getNumElements(), this.getMap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testCompute_presentToPresent() {
        MapComputeTester.assertEquals("Map.compute(present, functionReturningValue) should return new value", this.v3(), this.getMap().compute(this.k0(), (k, v) -> {
            MapComputeTester.assertEquals(this.k0(), k);
            MapComputeTester.assertEquals(this.v0(), v);
            return this.v3();
        }));
        this.expectReplacement(this.entry(this.k0(), this.v3()));
        MapComputeTester.assertEquals(this.getNumElements(), this.getMap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testCompute_presentToAbsent() {
        MapComputeTester.assertNull("Map.compute(present, functionReturningNull) should return null", this.getMap().compute(this.k0(), (k, v) -> {
            MapComputeTester.assertEquals(this.k0(), k);
            MapComputeTester.assertEquals(this.v0(), v);
            return null;
        }));
        this.expectMissing((Map.Entry)this.e0());
        this.expectMissingKeys(this.k0());
        MapComputeTester.assertEquals(this.getNumElements() - 1, this.getMap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testCompute_presentNullToPresentNonnull() {
        this.initMapWithNullValue();
        Object value = this.getValueForNullKey();
        MapComputeTester.assertEquals("Map.compute(presentMappedToNull, functionReturningValue) should return new value", value, this.getMap().compute(this.getKeyForNullValue(), (k, v) -> {
            MapComputeTester.assertEquals(this.getKeyForNullValue(), k);
            MapComputeTester.assertNull(v);
            return value;
        }));
        this.expectReplacement(this.entry(this.getKeyForNullValue(), value));
        MapComputeTester.assertEquals(this.getNumElements(), this.getMap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testCompute_presentNullToNull() {
        this.initMapWithNullValue();
        MapComputeTester.assertNull("Map.compute(presentMappedToNull, functionReturningNull) should return null", this.getMap().compute(this.getKeyForNullValue(), (k, v) -> {
            MapComputeTester.assertEquals(this.getKeyForNullValue(), k);
            MapComputeTester.assertNull(v);
            return null;
        }));
        this.expectMissingKeys(this.getKeyForNullValue());
        MapComputeTester.assertEquals(this.getNumElements() - 1, this.getMap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_NULL_KEYS})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testCompute_nullKeyPresentToPresent() {
        this.initMapWithNullKey();
        MapComputeTester.assertEquals("Map.compute(present, functionReturningValue) should return new value", this.v3(), this.getMap().compute(null, (k, v) -> {
            MapComputeTester.assertNull(k);
            MapComputeTester.assertEquals(this.getValueForNullKey(), v);
            return this.v3();
        }));
        MapComputeTester.assertEquals(this.getNumElements(), this.getMap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testCompute_presentFunctionThrows() {
        try {
            this.getMap().compute(this.k0(), (k, v) -> {
                MapComputeTester.assertEquals(this.k0(), k);
                MapComputeTester.assertEquals(this.v0(), v);
                throw new ExpectedException();
            });
            MapComputeTester.fail("Expected ExpectedException");
        }
        catch (ExpectedException expectedException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE})
    public void testCompute_absentFunctionThrows() {
        try {
            this.getMap().compute(this.k3(), (k, v) -> {
                MapComputeTester.assertEquals(this.k3(), k);
                MapComputeTester.assertNull(v);
                throw new ExpectedException();
            });
            MapComputeTester.fail("Expected ExpectedException");
        }
        catch (ExpectedException expectedException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    static class ExpectedException
    extends RuntimeException {
        ExpectedException() {
        }
    }
}

