/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.WrongType;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class MapContainsValueTester<K, V>
extends AbstractMapTester<K, V> {
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testContains_yes() {
        MapContainsValueTester.assertTrue("containsValue(present) should return true", this.getMap().containsValue(this.v0()));
    }

    public void testContains_no() {
        MapContainsValueTester.assertFalse("containsValue(notPresent) should return false", this.getMap().containsValue(this.v3()));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_VALUE_QUERIES})
    public void testContains_nullNotContainedButAllowed() {
        MapContainsValueTester.assertFalse("containsValue(null) should return false", this.getMap().containsValue(null));
    }

    @MapFeature.Require(absent={MapFeature.ALLOWS_NULL_VALUE_QUERIES})
    public void testContains_nullNotContainedAndUnsupported() {
        this.expectNullValueMissingWhenNullValuesUnsupported("containsValue(null) should return false or throw");
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testContains_nonNullWhenNullContained() {
        this.initMapWithNullValue();
        MapContainsValueTester.assertFalse("containsValue(notPresent) should return false", this.getMap().containsValue(this.v3()));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testContains_nullContained() {
        this.initMapWithNullValue();
        MapContainsValueTester.assertTrue("containsValue(null) should return true", this.getMap().containsValue(null));
    }

    public void testContains_wrongType() {
        try {
            MapContainsValueTester.assertFalse("containsValue(wrongType) should return false or throw", this.getMap().containsValue((Object)WrongType.VALUE));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }
}

