/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.features.CollectionSize;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class SortedMapNavigationTester<K, V>
extends AbstractMapTester<K, V> {
    private SortedMap<K, V> navigableMap;
    private Map.Entry<K, V> a;
    private Map.Entry<K, V> c;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.navigableMap = (SortedMap)this.getMap();
        List entries = Helpers.copyToList(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).getSampleElements(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).getCollectionSize().getNumElements()));
        Collections.sort(entries, Helpers.entryComparator(this.navigableMap.comparator()));
        if (entries.size() >= 1) {
            this.a = (Map.Entry)entries.get(0);
            if (entries.size() >= 3) {
                this.c = (Map.Entry)entries.get(2);
            }
        }
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEmptyMapFirst() {
        try {
            this.navigableMap.firstKey();
            SortedMapNavigationTester.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEmptyMapLast() {
        try {
            SortedMapNavigationTester.assertNull(this.navigableMap.lastKey());
            SortedMapNavigationTester.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testSingletonMapFirst() {
        SortedMapNavigationTester.assertEquals(this.a.getKey(), this.navigableMap.firstKey());
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testSingletonMapLast() {
        SortedMapNavigationTester.assertEquals(this.a.getKey(), this.navigableMap.lastKey());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testFirst() {
        SortedMapNavigationTester.assertEquals(this.a.getKey(), this.navigableMap.firstKey());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testLast() {
        SortedMapNavigationTester.assertEquals(this.c.getKey(), this.navigableMap.lastKey());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testHeadMapExclusive() {
        SortedMapNavigationTester.assertFalse(this.navigableMap.headMap(this.a.getKey()).containsKey(this.a.getKey()));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testTailMapInclusive() {
        SortedMapNavigationTester.assertTrue(this.navigableMap.tailMap(this.a.getKey()).containsKey(this.a.getKey()));
    }

    public void testHeadMap() {
        List entries = Helpers.copyToList(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).getSampleElements(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).getCollectionSize().getNumElements()));
        Collections.sort(entries, Helpers.entryComparator(this.navigableMap.comparator()));
        for (int i = 0; i < entries.size(); ++i) {
            Helpers.assertEqualInOrder(entries.subList(0, i), this.navigableMap.headMap(((Map.Entry)entries.get(i)).getKey()).entrySet());
        }
    }

    public void testTailMap() {
        List entries = Helpers.copyToList(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).getSampleElements(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).getCollectionSize().getNumElements()));
        Collections.sort(entries, Helpers.entryComparator(this.navigableMap.comparator()));
        for (int i = 0; i < entries.size(); ++i) {
            Helpers.assertEqualInOrder(entries.subList(i, entries.size()), this.navigableMap.tailMap(((Map.Entry)entries.get(i)).getKey()).entrySet());
        }
    }

    public void testSubMap() {
        List entries = Helpers.copyToList(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).getSampleElements(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).getCollectionSize().getNumElements()));
        Collections.sort(entries, Helpers.entryComparator(this.navigableMap.comparator()));
        for (int i = 0; i < entries.size(); ++i) {
            for (int j = i + 1; j < entries.size(); ++j) {
                Helpers.assertEqualInOrder(entries.subList(i, j), this.navigableMap.subMap(((Map.Entry)entries.get(i)).getKey(), ((Map.Entry)entries.get(j)).getKey()).entrySet());
            }
        }
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testSubMapIllegal() {
        try {
            this.navigableMap.subMap(this.c.getKey(), this.a.getKey());
            SortedMapNavigationTester.fail("Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testOrderedByComparator() {
        Comparator comparator = this.navigableMap.comparator();
        if (comparator == null) {
            comparator = new Comparator<K>(){

                @Override
                public int compare(K o1, K o2) {
                    return ((Comparable)o1).compareTo(o2);
                }
            };
        }
        Iterator<Map.Entry<K, V>> entryItr = this.navigableMap.entrySet().iterator();
        Map.Entry<K, V> prevEntry = entryItr.next();
        while (entryItr.hasNext()) {
            Map.Entry<K, V> nextEntry = entryItr.next();
            SortedMapNavigationTester.assertTrue(comparator.compare(prevEntry.getKey(), nextEntry.getKey()) < 0);
            prevEntry = nextEntry;
        }
    }
}

