/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.reflect.ClassPath;
import com.google.common.testing.ClassSanityTester;
import com.google.common.testing.ElementTypesAreNonnullByDefault;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.junit.Test;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
@J2ktIncompatible
public abstract class AbstractPackageSanityTests
extends TestCase {
    public static final Predicate<Class<?>> UNDERSCORE_IN_NAME = c -> c.getSimpleName().contains("_");
    private static final ImmutableList<String> NULL_TEST_METHOD_NAMES = ImmutableList.of("testNulls", "testNull", "testNullPointers", "testNullPointer", "testNullPointerExceptions", "testNullPointerException");
    private static final ImmutableList<String> SERIALIZABLE_TEST_METHOD_NAMES = ImmutableList.of("testSerializable", "testSerialization", "testEqualsAndSerializable", "testEqualsAndSerialization");
    private static final ImmutableList<String> EQUALS_TEST_METHOD_NAMES = ImmutableList.of("testEquals", "testEqualsAndHashCode", "testEqualsAndSerializable", "testEqualsAndSerialization", "testEquality");
    private static final Chopper TEST_SUFFIX = Chopper.suffix("Test").or(Chopper.suffix("Tests")).or(Chopper.suffix("TestCase")).or(Chopper.suffix("TestSuite"));
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final ClassSanityTester tester = new ClassSanityTester();
    private NullPointerTester.Visibility visibility = NullPointerTester.Visibility.PACKAGE;
    private Predicate<Class<?>> classFilter = cls -> this.visibility.isVisible(cls.getModifiers());

    protected final void publicApiOnly() {
        this.visibility = NullPointerTester.Visibility.PUBLIC;
    }

    @Test
    public void testSerializable() throws Exception {
        for (Class<?> classToTest : this.findClassesToTest(this.loadClassesInPackage(), SERIALIZABLE_TEST_METHOD_NAMES)) {
            if (!Serializable.class.isAssignableFrom(classToTest)) continue;
            try {
                Object instance = this.tester.instantiate(classToTest);
                if (instance == null) continue;
                if (AbstractPackageSanityTests.isEqualsDefined(classToTest)) {
                    SerializableTester.reserializeAndAssert(instance);
                    continue;
                }
                SerializableTester.reserialize(instance);
            }
            catch (Throwable e) {
                throw AbstractPackageSanityTests.sanityError(classToTest, SERIALIZABLE_TEST_METHOD_NAMES, "serializable test", e);
            }
        }
    }

    @Test
    public void testNulls() throws Exception {
        for (Class<?> classToTest : this.findClassesToTest(this.loadClassesInPackage(), NULL_TEST_METHOD_NAMES)) {
            try {
                this.tester.doTestNulls(classToTest, this.visibility);
            }
            catch (Throwable e) {
                throw AbstractPackageSanityTests.sanityError(classToTest, NULL_TEST_METHOD_NAMES, "nulls test", e);
            }
        }
    }

    @Test
    public void testEquals() throws Exception {
        for (Class<?> classToTest : this.findClassesToTest(this.loadClassesInPackage(), EQUALS_TEST_METHOD_NAMES)) {
            if (classToTest.isEnum() || !AbstractPackageSanityTests.isEqualsDefined(classToTest)) continue;
            try {
                this.tester.doTestEquals(classToTest);
            }
            catch (Throwable e) {
                throw AbstractPackageSanityTests.sanityError(classToTest, EQUALS_TEST_METHOD_NAMES, "equals test", e);
            }
        }
    }

    protected final <T> void setDefault(Class<T> type, T value) {
        this.tester.setDefault(type, value);
    }

    protected final <T> void setDistinctValues(Class<T> type, T value1, T value2) {
        this.tester.setDistinctValues(type, value1, value2);
    }

    protected final void ignoreClasses(Predicate<? super Class<?>> condition2) {
        this.classFilter = Predicates.and(this.classFilter, Predicates.not(condition2));
    }

    private static AssertionFailedError sanityError(Class<?> cls, List<String> explicitTestNames, String description, Throwable e) {
        String message2 = String.format(Locale.ROOT, "Error in automated %s of %s\nIf the class is better tested explicitly, you can add %s() to %sTest", description, cls, explicitTestNames.get(0), cls.getName());
        AssertionFailedError error = new AssertionFailedError(message2);
        error.initCause(e);
        return error;
    }

    @VisibleForTesting
    List<Class<?>> findClassesToTest(Iterable<? extends Class<?>> classes, Iterable<String> explicitTestNames) {
        TreeMap<String, Class<?>> classMap = Maps.newTreeMap();
        for (Class<?> cls : classes) {
            classMap.put(cls.getName(), cls);
        }
        HashMultimap<Class<?>, Class<?>> testClasses = HashMultimap.create();
        LinkedHashSet<Class<?>> candidateClasses = Sets.newLinkedHashSet();
        for (Class<?> cls : classes) {
            Optional<String> testedClassName = TEST_SUFFIX.chop(cls.getName());
            if (testedClassName.isPresent()) {
                Class testedClass = (Class)classMap.get(testedClassName.get());
                if (testedClass == null) continue;
                testClasses.put(testedClass, cls);
                continue;
            }
            candidateClasses.add(cls);
        }
        ArrayList<Class<?>> result = Lists.newArrayList();
        block2: for (Class<?> candidate : Iterables.filter(candidateClasses, this.classFilter)) {
            for (Class testClass : testClasses.get(candidate)) {
                if (!AbstractPackageSanityTests.hasTest(testClass, explicitTestNames)) continue;
                continue block2;
            }
            result.add(candidate);
        }
        return result;
    }

    private List<Class<?>> loadClassesInPackage() throws IOException {
        ArrayList<Class<?>> classes = Lists.newArrayList();
        String packageName = this.getClass().getPackage().getName();
        for (ClassPath.ClassInfo classInfo : ClassPath.from(this.getClass().getClassLoader()).getTopLevelClasses(packageName)) {
            Class<?> cls;
            try {
                cls = classInfo.load();
            }
            catch (NoClassDefFoundError e) {
                this.logger.log(Level.SEVERE, "Cannot load class " + classInfo + ", skipping...", e);
                continue;
            }
            if (cls.isInterface()) continue;
            classes.add(cls);
        }
        return classes;
    }

    private static boolean hasTest(Class<?> testClass, Iterable<String> testNames) {
        for (String testName : testNames) {
            try {
                testClass.getMethod(testName, new Class[0]);
                return true;
            }
            catch (NoSuchMethodException e) {
            }
        }
        return false;
    }

    private static boolean isEqualsDefined(Class<?> cls) {
        try {
            return !cls.getDeclaredMethod("equals", Object.class).isSynthetic();
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    static abstract class Chopper {
        Chopper() {
        }

        final Chopper or(final Chopper you) {
            final Chopper i = this;
            return new Chopper(){

                @Override
                Optional<String> chop(String str) {
                    return i.chop(str).or(you.chop(str));
                }
            };
        }

        abstract Optional<String> chop(String var1);

        static Chopper suffix(final String suffix) {
            return new Chopper(){

                @Override
                Optional<String> chop(String str) {
                    if (str.endsWith(suffix)) {
                        return Optional.of(str.substring(0, str.length() - suffix.length()));
                    }
                    return Optional.absent();
                }
            };
        }
    }
}

