/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.MutableClassToInstanceMap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.Parameter;
import com.google.common.reflect.Reflection;
import com.google.common.reflect.TypeToken;
import com.google.common.testing.ArbitraryInstances;
import com.google.common.testing.DummyProxy;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.FreshValueGenerator;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.RelationshipTester;
import com.google.common.testing.SerializableTester;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;

@GwtIncompatible
@J2ktIncompatible
public final class ClassSanityTester {
    private static final Ordering<Invokable<?, ?>> BY_METHOD_NAME = new Ordering<Invokable<?, ?>>(){

        @Override
        public int compare(Invokable<?, ?> left, Invokable<?, ?> right) {
            return left.getName().compareTo(right.getName());
        }
    };
    private static final Ordering<Invokable<?, ?>> BY_PARAMETERS = new Ordering<Invokable<?, ?>>(){

        @Override
        public int compare(Invokable<?, ?> left, Invokable<?, ?> right) {
            return Ordering.usingToString().compare(left.getParameters(), right.getParameters());
        }
    };
    private static final Ordering<Invokable<?, ?>> BY_NUMBER_OF_PARAMETERS = new Ordering<Invokable<?, ?>>(){

        @Override
        public int compare(Invokable<?, ?> left, Invokable<?, ?> right) {
            return Ints.compare(left.getParameters().size(), right.getParameters().size());
        }
    };
    private final MutableClassToInstanceMap<Object> defaultValues = MutableClassToInstanceMap.create();
    private final ListMultimap<Class<?>, Object> distinctValues = ArrayListMultimap.create();
    private final NullPointerTester nullPointerTester = new NullPointerTester();

    public ClassSanityTester() {
        this.setDefault(Byte.TYPE, (byte)1);
        this.setDefault(Byte.class, (byte)1);
        this.setDefault(Short.TYPE, (short)1);
        this.setDefault(Short.class, (short)1);
        this.setDefault(Integer.TYPE, 1);
        this.setDefault(Integer.class, 1);
        this.setDefault(Long.TYPE, 1L);
        this.setDefault(Long.class, 1L);
        this.setDefault(Float.TYPE, Float.valueOf(1.0f));
        this.setDefault(Float.class, Float.valueOf(1.0f));
        this.setDefault(Double.TYPE, 1.0);
        this.setDefault(Double.class, 1.0);
        this.setDefault(Class.class, Class.class);
    }

    @CanIgnoreReturnValue
    public <T> ClassSanityTester setDefault(Class<T> type, T value) {
        this.nullPointerTester.setDefault(type, value);
        this.defaultValues.putInstance(type, value);
        return this;
    }

    @CanIgnoreReturnValue
    public <T> ClassSanityTester setDistinctValues(Class<T> type, T value1, T value2) {
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull(value1);
        Preconditions.checkNotNull(value2);
        Preconditions.checkArgument(!Objects.equal(value1, value2), "Duplicate value provided.");
        this.distinctValues.replaceValues((Object)type, ImmutableList.of(value1, value2));
        this.setDefault(type, value1);
        return this;
    }

    public void testNulls(Class<?> cls) {
        try {
            this.doTestNulls(cls, NullPointerTester.Visibility.PACKAGE);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    void doTestNulls(Class<?> cls, NullPointerTester.Visibility visibility) throws ParameterNotInstantiableException, IllegalAccessException, InvocationTargetException, FactoryMethodReturnsNullException {
        Object instance;
        if (!Modifier.isAbstract(cls.getModifiers())) {
            this.nullPointerTester.testConstructors(cls, visibility);
        }
        this.nullPointerTester.testStaticMethods(cls, visibility);
        if (this.hasInstanceMethodToTestNulls(cls, visibility) && (instance = this.instantiate(cls)) != null) {
            this.nullPointerTester.testInstanceMethods(instance, visibility);
        }
    }

    private boolean hasInstanceMethodToTestNulls(Class<?> c, NullPointerTester.Visibility visibility) {
        for (Method method : this.nullPointerTester.getInstanceMethodsToTest(c, visibility)) {
            for (Parameter param : Invokable.from(method).getParameters()) {
                if (NullPointerTester.isPrimitiveOrNullable(param)) continue;
                return true;
            }
        }
        return false;
    }

    public void testEquals(Class<?> cls) {
        try {
            this.doTestEquals(cls);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    void doTestEquals(Class<?> cls) throws ParameterNotInstantiableException, ParameterHasNoDistinctValueException, IllegalAccessException, InvocationTargetException, FactoryMethodReturnsNullException {
        if (cls.isEnum()) {
            return;
        }
        List<Invokable<?, ?>> factories = Lists.reverse(ClassSanityTester.getFactories(TypeToken.of(cls)));
        if (factories.isEmpty()) {
            return;
        }
        int numberOfParameters = factories.get(0).getParameters().size();
        ArrayList<ParameterNotInstantiableException> paramErrors = Lists.newArrayList();
        ArrayList<ParameterHasNoDistinctValueException> distinctValueErrors = Lists.newArrayList();
        ArrayList<InvocationTargetException> instantiationExceptions = Lists.newArrayList();
        ArrayList<FactoryMethodReturnsNullException> nullErrors = Lists.newArrayList();
        for (Invokable<?, ?> factory : factories) {
            if (factory.getParameters().size() != numberOfParameters) continue;
            try {
                this.testEqualsUsing(factory);
                return;
            }
            catch (ParameterNotInstantiableException e) {
                paramErrors.add(e);
            }
            catch (ParameterHasNoDistinctValueException e) {
                distinctValueErrors.add(e);
            }
            catch (InvocationTargetException e) {
                instantiationExceptions.add(e);
            }
            catch (FactoryMethodReturnsNullException e) {
                nullErrors.add(e);
            }
        }
        ClassSanityTester.throwFirst(paramErrors);
        ClassSanityTester.throwFirst(distinctValueErrors);
        ClassSanityTester.throwFirst(instantiationExceptions);
        ClassSanityTester.throwFirst(nullErrors);
    }

    <T> T instantiate(Class<T> cls) throws ParameterNotInstantiableException, IllegalAccessException, InvocationTargetException, FactoryMethodReturnsNullException {
        if (cls.isEnum()) {
            T[] constants = cls.getEnumConstants();
            if (constants != null && constants.length > 0) {
                return constants[0];
            }
            return null;
        }
        TypeToken<T> type = TypeToken.of(cls);
        ArrayList<ParameterNotInstantiableException> paramErrors = Lists.newArrayList();
        ArrayList<InvocationTargetException> instantiationExceptions = Lists.newArrayList();
        ArrayList<FactoryMethodReturnsNullException> nullErrors = Lists.newArrayList();
        for (Invokable invokable : ClassSanityTester.getFactories(type)) {
            T instance;
            try {
                instance = this.instantiate(invokable);
            }
            catch (ParameterNotInstantiableException e) {
                paramErrors.add(e);
                continue;
            }
            catch (InvocationTargetException e) {
                instantiationExceptions.add(e);
                continue;
            }
            if (instance == null) {
                nullErrors.add(new FactoryMethodReturnsNullException(invokable));
                continue;
            }
            return instance;
        }
        ClassSanityTester.throwFirst(paramErrors);
        ClassSanityTester.throwFirst(instantiationExceptions);
        ClassSanityTester.throwFirst(nullErrors);
        return null;
    }

    private <T> T instantiate(Invokable<?, ? extends T> factory) throws ParameterNotInstantiableException, InvocationTargetException, IllegalAccessException {
        return ClassSanityTester.invoke(factory, this.getDummyArguments(factory));
    }

    public FactoryMethodReturnValueTester forAllPublicStaticMethods(Class<?> cls) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Method method : cls.getDeclaredMethods()) {
            Invokable<?, Object> invokable = Invokable.from(method);
            invokable.setAccessible(true);
            if (!invokable.isPublic() || !invokable.isStatic() || invokable.isSynthetic()) continue;
            builder.add(invokable);
        }
        return new FactoryMethodReturnValueTester(cls, (ImmutableList)builder.build(), "public static methods");
    }

    private void testEqualsUsing(final Invokable<?, ?> factory) throws ParameterNotInstantiableException, ParameterHasNoDistinctValueException, IllegalAccessException, InvocationTargetException, FactoryMethodReturnsNullException {
        ImmutableList<Parameter> params = factory.getParameters();
        ArrayList<FreshValueGenerator> argGenerators = Lists.newArrayListWithCapacity(params.size());
        ArrayList<Object> args = Lists.newArrayListWithCapacity(params.size());
        for (Parameter param : params) {
            FreshValueGenerator generator = this.newFreshValueGenerator();
            argGenerators.add(generator);
            args.add(ClassSanityTester.generateDummyArg(param, generator));
        }
        Object instance = ClassSanityTester.createInstance(factory, args);
        List<Object> equalArgs = this.generateEqualFactoryArguments(factory, params, args);
        final ArrayList<ImmutableList<List<Object>>> argGroups = Lists.newArrayList();
        argGroups.add(ImmutableList.of(args, equalArgs));
        EqualsTester tester = new EqualsTester(new RelationshipTester.ItemReporter(){

            @Override
            String reportItem(RelationshipTester.Item<?> item) {
                List factoryArgs = (List)((List)argGroups.get(item.groupNumber)).get(item.itemNumber);
                return factory.getName() + "(" + Joiner.on(", ").useForNull("null").join(factoryArgs) + ")";
            }
        });
        tester.addEqualityGroup(instance, ClassSanityTester.createInstance(factory, equalArgs));
        for (int i = 0; i < params.size(); ++i) {
            ArrayList<Object> newArgs = Lists.newArrayList(args);
            Object newArg = ((FreshValueGenerator)argGenerators.get(i)).generateFresh(((Parameter)params.get(i)).getType());
            if (newArg == null || Objects.equal(args.get(i), newArg)) {
                if (((Parameter)params.get(i)).getType().getRawType().isEnum()) continue;
                throw new ParameterHasNoDistinctValueException((Parameter)params.get(i));
            }
            newArgs.set(i, newArg);
            tester.addEqualityGroup(ClassSanityTester.createInstance(factory, newArgs));
            argGroups.add(ImmutableList.of(newArgs));
        }
        tester.testEquals();
    }

    private List<Object> generateEqualFactoryArguments(Invokable<?, ?> factory, List<Parameter> params, List<Object> args) throws ParameterNotInstantiableException, FactoryMethodReturnsNullException, InvocationTargetException, IllegalAccessException {
        ArrayList<Object> equalArgs = Lists.newArrayList(args);
        for (int i = 0; i < args.size(); ++i) {
            Object shouldBeEqualArg;
            Parameter param = params.get(i);
            Object arg = args.get(i);
            if (arg == (shouldBeEqualArg = ClassSanityTester.generateDummyArg(param, this.newFreshValueGenerator())) || !Objects.equal(arg, shouldBeEqualArg) || !ClassSanityTester.hashCodeInsensitiveToArgReference(factory, args, i, shouldBeEqualArg) || !ClassSanityTester.hashCodeInsensitiveToArgReference(factory, args, i, ClassSanityTester.generateDummyArg(param, this.newFreshValueGenerator()))) continue;
            equalArgs.set(i, shouldBeEqualArg);
        }
        return equalArgs;
    }

    private static boolean hashCodeInsensitiveToArgReference(Invokable<?, ?> factory, List<Object> args, int i, Object alternateArg) throws FactoryMethodReturnsNullException, InvocationTargetException, IllegalAccessException {
        ArrayList<Object> tentativeArgs = Lists.newArrayList(args);
        tentativeArgs.set(i, alternateArg);
        return ClassSanityTester.createInstance(factory, tentativeArgs).hashCode() == ClassSanityTester.createInstance(factory, args).hashCode();
    }

    private FreshValueGenerator newFreshValueGenerator() {
        FreshValueGenerator generator = new FreshValueGenerator(){

            @Override
            Object interfaceMethodCalled(Class<?> interfaceType, Method method) {
                return ClassSanityTester.this.getDummyValue(TypeToken.of(interfaceType).method(method).getReturnType());
            }
        };
        for (Map.Entry<Class<?>, Collection<Object>> entry : this.distinctValues.asMap().entrySet()) {
            generator.addSampleInstances(entry.getKey(), (Iterable)entry.getValue());
        }
        return generator;
    }

    private static Object generateDummyArg(Parameter param, FreshValueGenerator generator) throws ParameterNotInstantiableException {
        if (NullPointerTester.isNullable(param)) {
            return null;
        }
        Object arg = generator.generateFresh(param.getType());
        if (arg == null) {
            throw new ParameterNotInstantiableException(param);
        }
        return arg;
    }

    private static <X extends Throwable> void throwFirst(List<X> exceptions) throws X {
        if (!exceptions.isEmpty()) {
            throw (Throwable)exceptions.get(0);
        }
    }

    private static <T> ImmutableList<Invokable<?, ? extends T>> getFactories(TypeToken<T> type) {
        Invokable<T, Object> invokable;
        ArrayList<Invokable<T, Object>> factories = Lists.newArrayList();
        for (Method method : type.getRawType().getDeclaredMethods()) {
            invokable = type.method(method);
            if (invokable.isPrivate() || invokable.isSynthetic() || !invokable.isStatic() || !type.isSupertypeOf(invokable.getReturnType())) continue;
            Invokable<T, Object> factory = invokable;
            factories.add(factory);
        }
        if (!Modifier.isAbstract(type.getRawType().getModifiers())) {
            for (Constructor<?> constructor : type.getRawType().getDeclaredConstructors()) {
                invokable = type.constructor(constructor);
                if (invokable.isPrivate() || invokable.isSynthetic()) continue;
                factories.add(invokable);
            }
        }
        for (Invokable invokable2 : factories) {
            invokable2.setAccessible(true);
        }
        return BY_NUMBER_OF_PARAMETERS.compound(BY_METHOD_NAME).compound(BY_PARAMETERS).immutableSortedCopy(factories);
    }

    private List<Object> getDummyArguments(Invokable<?, ?> invokable) throws ParameterNotInstantiableException {
        ArrayList<Object> args = Lists.newArrayList();
        for (Parameter param : invokable.getParameters()) {
            if (NullPointerTester.isNullable(param)) {
                args.add(null);
                continue;
            }
            Object defaultValue = this.getDummyValue(param.getType());
            if (defaultValue == null) {
                throw new ParameterNotInstantiableException(param);
            }
            args.add(defaultValue);
        }
        return args;
    }

    private <T> T getDummyValue(TypeToken<T> type) {
        Class<T> rawType = type.getRawType();
        T defaultValue = this.defaultValues.getInstance(rawType);
        if (defaultValue != null) {
            return defaultValue;
        }
        T value = ArbitraryInstances.get(rawType);
        if (value != null) {
            return value;
        }
        if (rawType.isInterface()) {
            return new SerializableDummyProxy(this).newProxy(type);
        }
        return null;
    }

    private static <T> T createInstance(Invokable<?, ? extends T> factory, List<?> args) throws FactoryMethodReturnsNullException, InvocationTargetException, IllegalAccessException {
        T instance = ClassSanityTester.invoke(factory, args);
        if (instance == null) {
            throw new FactoryMethodReturnsNullException(factory);
        }
        return instance;
    }

    private static <T> T invoke(Invokable<?, ? extends T> factory, List<?> args) throws InvocationTargetException, IllegalAccessException {
        T returnValue = factory.invoke(null, args.toArray());
        if (returnValue == null) {
            Assert.assertTrue(factory + " returns null but it's not annotated with @Nullable", NullPointerTester.isNullable(factory));
        }
        return returnValue;
    }

    @VisibleForTesting
    static class ParameterNotInstantiableException
    extends Exception {
        public ParameterNotInstantiableException(Parameter parameter) {
            super("Cannot determine value for parameter " + parameter + " of " + parameter.getDeclaringInvokable());
        }
    }

    @VisibleForTesting
    static class ParameterHasNoDistinctValueException
    extends Exception {
        ParameterHasNoDistinctValueException(Parameter parameter) {
            super("Cannot generate distinct value for parameter " + parameter + " of " + parameter.getDeclaringInvokable());
        }
    }

    @VisibleForTesting
    static class FactoryMethodReturnsNullException
    extends Exception {
        public FactoryMethodReturnsNullException(Invokable<?, ?> factory) {
            super(factory + " returns null and cannot be used to test instance methods.");
        }
    }

    public final class FactoryMethodReturnValueTester {
        private final Set<String> packagesToTest = Sets.newHashSet();
        private final Class<?> declaringClass;
        private final ImmutableList<Invokable<?, ?>> factories;
        private final String factoryMethodsDescription;
        private Class<?> returnTypeToTest = Object.class;

        private FactoryMethodReturnValueTester(Class<?> declaringClass, ImmutableList<Invokable<?, ?>> factories, String factoryMethodsDescription) {
            this.declaringClass = declaringClass;
            this.factories = factories;
            this.factoryMethodsDescription = factoryMethodsDescription;
            this.packagesToTest.add(Reflection.getPackageName(declaringClass));
        }

        @CanIgnoreReturnValue
        public FactoryMethodReturnValueTester thatReturn(Class<?> returnType) {
            this.returnTypeToTest = returnType;
            return this;
        }

        @CanIgnoreReturnValue
        public FactoryMethodReturnValueTester testNulls() throws Exception {
            for (Invokable invokable : this.getFactoriesToTest()) {
                Object instance = ClassSanityTester.this.instantiate(invokable);
                if (instance == null || !this.packagesToTest.contains(Reflection.getPackageName(instance.getClass()))) continue;
                try {
                    ClassSanityTester.this.nullPointerTester.testAllPublicInstanceMethods(instance);
                }
                catch (AssertionError e) {
                    AssertionFailedError error = new AssertionFailedError("Null check failed on return value of " + invokable);
                    ((Throwable)((Object)error)).initCause((Throwable)((Object)e));
                    throw error;
                }
            }
            return this;
        }

        @CanIgnoreReturnValue
        public FactoryMethodReturnValueTester testEquals() throws Exception {
            for (Invokable invokable : this.getFactoriesToTest()) {
                try {
                    ClassSanityTester.this.testEqualsUsing(invokable);
                }
                catch (FactoryMethodReturnsNullException factoryMethodReturnsNullException) {}
            }
            return this;
        }

        @CanIgnoreReturnValue
        public FactoryMethodReturnValueTester testSerializable() throws Exception {
            for (Invokable invokable : this.getFactoriesToTest()) {
                Object instance = ClassSanityTester.this.instantiate(invokable);
                if (instance == null) continue;
                try {
                    SerializableTester.reserialize(instance);
                }
                catch (RuntimeException e) {
                    AssertionFailedError error = new AssertionFailedError("Serialization failed on return value of " + invokable);
                    ((Throwable)((Object)error)).initCause(e.getCause());
                    throw error;
                }
            }
            return this;
        }

        @CanIgnoreReturnValue
        public FactoryMethodReturnValueTester testEqualsAndSerializable() throws Exception {
            for (Invokable invokable : this.getFactoriesToTest()) {
                Object instance;
                try {
                    ClassSanityTester.this.testEqualsUsing(invokable);
                }
                catch (FactoryMethodReturnsNullException factoryMethodReturnsNullException) {
                    // empty catch block
                }
                if ((instance = ClassSanityTester.this.instantiate(invokable)) == null) continue;
                try {
                    SerializableTester.reserializeAndAssert(instance);
                }
                catch (RuntimeException e) {
                    AssertionFailedError error = new AssertionFailedError("Serialization failed on return value of " + invokable);
                    ((Throwable)((Object)error)).initCause(e.getCause());
                    throw error;
                }
                catch (AssertionFailedError e) {
                    AssertionFailedError error = new AssertionFailedError("Return value of " + invokable + " reserialized to an unequal value");
                    ((Throwable)((Object)error)).initCause((Throwable)((Object)e));
                    throw error;
                }
            }
            return this;
        }

        private ImmutableList<Invokable<?, ?>> getFactoriesToTest() {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Invokable invokable : this.factories) {
                if (!this.returnTypeToTest.isAssignableFrom(invokable.getReturnType().getRawType())) continue;
                builder.add(invokable);
            }
            ImmutableCollection factoriesToTest = builder.build();
            Assert.assertFalse("No " + this.factoryMethodsDescription + " that return " + this.returnTypeToTest.getName() + " or subtype are found in " + this.declaringClass + ".", factoriesToTest.isEmpty());
            return factoriesToTest;
        }
    }

    private static final class SerializableDummyProxy
    extends DummyProxy
    implements Serializable {
        private final transient ClassSanityTester tester;

        SerializableDummyProxy(ClassSanityTester tester) {
            this.tester = tester;
        }

        @Override
        <R> R dummyReturnValue(TypeToken<R> returnType) {
            return (R)this.tester.getDummyValue(returnType);
        }

        public boolean equals(Object obj) {
            return obj instanceof SerializableDummyProxy;
        }

        public int hashCode() {
            return 0;
        }
    }
}

