/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.reflect.AbstractInvocationHandler;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.Parameter;
import com.google.common.reflect.TypeToken;
import com.google.common.testing.ElementTypesAreNonnullByDefault;
import com.google.common.testing.NullPointerTester;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashSet;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
@J2ktIncompatible
abstract class DummyProxy {
    DummyProxy() {
    }

    final <T> T newProxy(TypeToken<T> interfaceType) {
        Object dummy;
        LinkedHashSet<Class<Object>> interfaceClasses = Sets.newLinkedHashSet();
        interfaceClasses.addAll(interfaceType.getTypes().interfaces().rawTypes());
        interfaceClasses.add(Serializable.class);
        Object result = dummy = Proxy.newProxyInstance(((Class)interfaceClasses.iterator().next()).getClassLoader(), interfaceClasses.toArray(new Class[interfaceClasses.size()]), (InvocationHandler)new DummyHandler(interfaceType));
        return (T)result;
    }

    abstract <R> R dummyReturnValue(TypeToken<R> var1);

    private class DummyHandler
    extends AbstractInvocationHandler
    implements Serializable {
        private final TypeToken<?> interfaceType;

        DummyHandler(TypeToken<?> interfaceType) {
            this.interfaceType = interfaceType;
        }

        @Override
        protected Object handleInvocation(Object proxy, Method method, Object[] args) {
            Invokable<?, Object> invokable = this.interfaceType.method(method);
            ImmutableList<Parameter> params = invokable.getParameters();
            for (int i = 0; i < args.length; ++i) {
                Parameter param = (Parameter)params.get(i);
                if (NullPointerTester.isNullable(param)) continue;
                Preconditions.checkNotNull(args[i]);
            }
            return DummyProxy.this.dummyReturnValue(this.interfaceType.resolveType(method.getGenericReturnType()));
        }

        @Override
        public int hashCode() {
            return this.identity().hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof DummyHandler) {
                DummyHandler that = (DummyHandler)obj;
                return this.identity().equals(that.identity());
            }
            return false;
        }

        private DummyProxy identity() {
            return DummyProxy.this;
        }

        @Override
        public String toString() {
            return "Dummy proxy for " + this.interfaceType;
        }

        private Object writeReplace() {
            return new DummyHandler(TypeToken.of(this.interfaceType.getRawType()));
        }
    }
}

