/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;

public abstract class ComparableSubject<T extends Comparable<?>>
extends Subject {
    private final T actual;

    protected ComparableSubject(FailureMetadata metadata, T actual) {
        super(metadata, actual);
        this.actual = actual;
    }

    public final void isIn(Range<T> range) {
        if (!range.contains((Comparable)Preconditions.checkNotNull(this.actual))) {
            this.failWithActual("expected to be in range", range);
        }
    }

    public final void isNotIn(Range<T> range) {
        if (range.contains((Comparable)Preconditions.checkNotNull(this.actual))) {
            this.failWithActual("expected not to be in range", range);
        }
    }

    public void isEquivalentAccordingToCompareTo(T expected) {
        if (((Comparable)Preconditions.checkNotNull(this.actual)).compareTo(Preconditions.checkNotNull(expected)) != 0) {
            this.failWithActual("expected value that sorts equal to", expected);
        }
    }

    public final void isGreaterThan(T other) {
        if (((Comparable)Preconditions.checkNotNull(this.actual)).compareTo(Preconditions.checkNotNull(other)) <= 0) {
            this.failWithActual("expected to be greater than", other);
        }
    }

    public final void isLessThan(T other) {
        if (((Comparable)Preconditions.checkNotNull(this.actual)).compareTo(Preconditions.checkNotNull(other)) >= 0) {
            this.failWithActual("expected to be less than", other);
        }
    }

    public final void isAtMost(T other) {
        if (((Comparable)Preconditions.checkNotNull(this.actual)).compareTo(Preconditions.checkNotNull(other)) > 0) {
            this.failWithActual("expected to be at most", other);
        }
    }

    public final void isAtLeast(T other) {
        if (((Comparable)Preconditions.checkNotNull(this.actual)).compareTo(Preconditions.checkNotNull(other)) < 0) {
            this.failWithActual("expected to be at least", other);
        }
    }
}

