/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.truth.J2ktIncompatible;
import com.google.common.truth.Platform;
import com.google.common.truth.SimpleSubjectBuilder;
import com.google.common.truth.StandardSubjectBuilder;
import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthFailureSubject;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class ExpectFailure
implements Platform.JUnitTestRule {
    private boolean inRuleContext = false;
    private boolean failureExpected = false;
    private AssertionError failure = null;

    public StandardSubjectBuilder whenTesting() {
        Preconditions.checkState(this.inRuleContext, "ExpectFailure must be used as a JUnit @Rule");
        if (this.failure != null) {
            throw Truth.SimpleAssertionError.create("ExpectFailure already captured a failure", (Throwable)((Object)this.failure));
        }
        if (this.failureExpected) {
            throw new AssertionError((Object)"ExpectFailure.whenTesting() called previously, but did not capture a failure.");
        }
        this.failureExpected = true;
        return StandardSubjectBuilder.forCustomFailureStrategy(this::captureFailure);
    }

    void enterRuleContext() {
        this.inRuleContext = true;
    }

    void leaveRuleContext() {
        this.inRuleContext = false;
    }

    void ensureFailureCaught() {
        if (this.failureExpected && this.failure == null) {
            throw new AssertionError((Object)"ExpectFailure.whenTesting() invoked, but no failure was caught.");
        }
    }

    public AssertionError getFailure() {
        if (this.failure == null) {
            throw new AssertionError((Object)"ExpectFailure did not capture a failure.");
        }
        return this.failure;
    }

    private void captureFailure(AssertionError captured) {
        if (this.failure != null) {
            throw new AssertionError((Object)Strings.lenientFormat("ExpectFailure.whenTesting() caught multiple failures:\n\n%s\n\n%s\n", Platform.getStackTraceAsString((Throwable)((Object)this.failure)), Platform.getStackTraceAsString((Throwable)((Object)captured))));
        }
        this.failure = captured;
    }

    @CanIgnoreReturnValue
    public static AssertionError expectFailure(StandardSubjectBuilderCallback assertionCallback) {
        ExpectFailure expectFailure = new ExpectFailure();
        expectFailure.enterRuleContext();
        assertionCallback.invokeAssertion(expectFailure.whenTesting());
        return expectFailure.getFailure();
    }

    @CanIgnoreReturnValue
    public static <S extends Subject, A> AssertionError expectFailureAbout(Subject.Factory<S, A> factory, SimpleSubjectBuilderCallback<S, A> assertionCallback) {
        return ExpectFailure.expectFailure(whenTesting -> assertionCallback.invokeAssertion(whenTesting.about(factory)));
    }

    public static TruthFailureSubject assertThat(AssertionError actual) {
        return Truth.assertAbout(TruthFailureSubject.truthFailures()).that(actual);
    }

    @Override
    @GwtIncompatible(value="org.junit.rules.TestRule")
    @J2ktIncompatible
    public Statement apply(final Statement base, Description description) {
        Preconditions.checkNotNull(base);
        Preconditions.checkNotNull(description);
        return new Statement(){

            @Override
            public void evaluate() throws Throwable {
                ExpectFailure.this.enterRuleContext();
                try {
                    base.evaluate();
                }
                finally {
                    ExpectFailure.this.leaveRuleContext();
                }
                ExpectFailure.this.ensureFailureCaught();
            }
        };
    }

    public static interface StandardSubjectBuilderCallback {
        public void invokeAssertion(StandardSubjectBuilder var1);
    }

    public static interface SimpleSubjectBuilderCallback<S extends Subject, A> {
        public void invokeAssertion(SimpleSubjectBuilder<S, A> var1);
    }
}

