/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;

final class LazyMessage {
    private final String format;
    private final Object[] args;

    LazyMessage(String format, Object ... args) {
        this.format = format;
        this.args = args;
        int placeholders = LazyMessage.countPlaceholders(format);
        Preconditions.checkArgument(placeholders == args.length, "Incorrect number of args (%s) for the given placeholders (%s) in string template:\"%s\"", (Object)args.length, (Object)placeholders, (Object)format);
    }

    public String toString() {
        return Strings.lenientFormat(this.format, this.args);
    }

    @VisibleForTesting
    static int countPlaceholders(String template) {
        int index = 0;
        int count = 0;
        while ((index = template.indexOf("%s", index)) != -1) {
            ++index;
            ++count;
        }
        return count;
    }

    static ImmutableList<String> evaluateAll(ImmutableList<LazyMessage> messages) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (LazyMessage message2 : messages) {
            result.add(message2.toString());
        }
        return result.build();
    }
}

