/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.truth.ComparableSubject;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.J2ktIncompatible;
import com.google.common.truth.Platform;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringSubject
extends ComparableSubject<String> {
    private final String actual;

    protected StringSubject(FailureMetadata metadata, String string) {
        super(metadata, string);
        this.actual = string;
    }

    @Override
    @Deprecated
    public final void isEquivalentAccordingToCompareTo(String other) {
        super.isEquivalentAccordingToCompareTo(other);
    }

    public void hasLength(int expectedLength) {
        Preconditions.checkArgument(expectedLength >= 0, "expectedLength(%s) must be >= 0", expectedLength);
        this.check("length()", new Object[0]).that(Preconditions.checkNotNull(this.actual).length()).isEqualTo(expectedLength);
    }

    public void isEmpty() {
        if (this.actual == null) {
            this.failWithActual(Fact.simpleFact("expected an empty string"), new Fact[0]);
        } else if (!this.actual.isEmpty()) {
            this.failWithActual(Fact.simpleFact("expected to be empty"), new Fact[0]);
        }
    }

    public void isNotEmpty() {
        if (this.actual == null) {
            this.failWithActual(Fact.simpleFact("expected a non-empty string"), new Fact[0]);
        } else if (this.actual.isEmpty()) {
            this.failWithoutActual(Fact.simpleFact("expected not to be empty"), new Fact[0]);
        }
    }

    public void contains(CharSequence string) {
        Preconditions.checkNotNull(string);
        if (this.actual == null) {
            this.failWithActual("expected a string that contains", string);
        } else if (!this.actual.contains(string)) {
            this.failWithActual("expected to contain", string);
        }
    }

    public void doesNotContain(CharSequence string) {
        Preconditions.checkNotNull(string);
        if (this.actual == null) {
            this.failWithActual("expected a string that does not contain", string);
        } else if (this.actual.contains(string)) {
            this.failWithActual("expected not to contain", string);
        }
    }

    public void startsWith(String string) {
        Preconditions.checkNotNull(string);
        if (this.actual == null) {
            this.failWithActual("expected a string that starts with", string);
        } else if (!this.actual.startsWith(string)) {
            this.failWithActual("expected to start with", string);
        }
    }

    public void endsWith(String string) {
        Preconditions.checkNotNull(string);
        if (this.actual == null) {
            this.failWithActual("expected a string that ends with", string);
        } else if (!this.actual.endsWith(string)) {
            this.failWithActual("expected to end with", string);
        }
    }

    public void matches(String regex) {
        Preconditions.checkNotNull(regex);
        if (this.actual == null) {
            this.failWithActual("expected a string that matches", regex);
        } else if (!this.actual.matches(regex)) {
            if (regex.equals(this.actual)) {
                this.failWithoutActual(Fact.fact("expected to match", regex), Fact.fact("but was", this.actual), Fact.simpleFact("Looks like you want to use .isEqualTo() for an exact equality assertion."));
            } else {
                this.failWithActual("expected to match", regex);
            }
        }
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    @J2ktIncompatible
    public void matches(Pattern regex) {
        Preconditions.checkNotNull(regex);
        if (this.actual == null) {
            this.failWithActual("expected a string that matches", regex);
        } else if (!regex.matcher(this.actual).matches()) {
            if (regex.toString().equals(this.actual)) {
                this.failWithoutActual(Fact.fact("expected to match", regex), Fact.fact("but was", this.actual), Fact.simpleFact("If you want an exact equality assertion you can escape your regex with Pattern.quote()."));
            } else {
                this.failWithActual("expected to match", regex);
            }
        }
    }

    public void doesNotMatch(String regex) {
        Preconditions.checkNotNull(regex);
        if (this.actual == null) {
            this.failWithActual("expected a string that does not match", regex);
        } else if (this.actual.matches(regex)) {
            this.failWithActual("expected not to match", regex);
        }
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    @J2ktIncompatible
    public void doesNotMatch(Pattern regex) {
        Preconditions.checkNotNull(regex);
        if (this.actual == null) {
            this.failWithActual("expected a string that does not match", regex);
        } else if (regex.matcher(this.actual).matches()) {
            this.failWithActual("expected not to match", regex);
        }
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    @J2ktIncompatible
    public void containsMatch(Pattern regex) {
        Preconditions.checkNotNull(regex);
        if (this.actual == null) {
            this.failWithActual("expected a string that contains a match for", regex);
        } else if (!regex.matcher(this.actual).find()) {
            this.failWithActual("expected to contain a match for", regex);
        }
    }

    public void containsMatch(String regex) {
        Preconditions.checkNotNull(regex);
        if (this.actual == null) {
            this.failWithActual("expected a string that contains a match for", regex);
        } else if (!Platform.containsMatch(this.actual, regex)) {
            this.failWithActual("expected to contain a match for", regex);
        }
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    @J2ktIncompatible
    public void doesNotContainMatch(Pattern regex) {
        Preconditions.checkNotNull(regex);
        if (this.actual == null) {
            this.failWithActual("expected a string that does not contain a match for", regex);
            return;
        }
        Matcher matcher = regex.matcher(this.actual);
        if (matcher.find()) {
            this.failWithoutActual(Fact.fact("expected not to contain a match for", regex), Fact.fact("but contained", matcher.group()), Fact.fact("full string", this.actualCustomStringRepresentationForPackageMembersToCall()));
        }
    }

    public void doesNotContainMatch(String regex) {
        Preconditions.checkNotNull(regex);
        if (this.actual == null) {
            this.failWithActual("expected a string that does not contain a match for", regex);
        } else if (Platform.containsMatch(this.actual, regex)) {
            this.failWithActual("expected not to contain a match for", regex);
        }
    }

    public CaseInsensitiveStringComparison ignoringCase() {
        return new CaseInsensitiveStringComparison();
    }

    public final class CaseInsensitiveStringComparison {
        private CaseInsensitiveStringComparison() {
        }

        public void isEqualTo(String expected) {
            if (StringSubject.this.actual == null) {
                if (expected != null) {
                    StringSubject.this.failWithoutActual(Fact.fact("expected a string that is equal to", expected), StringSubject.this.butWas(), Fact.simpleFact("(case is ignored)"));
                }
            } else if (expected == null) {
                StringSubject.this.failWithoutActual(Fact.fact("expected", "null (null reference)"), StringSubject.this.butWas(), Fact.simpleFact("(case is ignored)"));
            } else if (!StringSubject.this.actual.equalsIgnoreCase(expected)) {
                StringSubject.this.failWithoutActual(Fact.fact("expected", expected), StringSubject.this.butWas(), Fact.simpleFact("(case is ignored)"));
            }
        }

        public void isNotEqualTo(String unexpected) {
            if (StringSubject.this.actual == null) {
                if (unexpected == null) {
                    StringSubject.this.failWithoutActual(Fact.fact("expected a string that is not equal to", "null (null reference)"), Fact.simpleFact("(case is ignored)"));
                }
            } else if (unexpected != null && StringSubject.this.actual.equalsIgnoreCase(unexpected)) {
                StringSubject.this.failWithoutActual(Fact.fact("expected not to be", unexpected), StringSubject.this.butWas(), Fact.simpleFact("(case is ignored)"));
            }
        }

        public void contains(CharSequence expectedSequence) {
            Preconditions.checkNotNull(expectedSequence);
            String expected = expectedSequence.toString();
            if (StringSubject.this.actual == null) {
                StringSubject.this.failWithoutActual(Fact.fact("expected a string that contains", expected), StringSubject.this.butWas(), Fact.simpleFact("(case is ignored)"));
            } else if (!this.containsIgnoreCase(expected)) {
                StringSubject.this.failWithoutActual(Fact.fact("expected to contain", expected), StringSubject.this.butWas(), Fact.simpleFact("(case is ignored)"));
            }
        }

        public void doesNotContain(CharSequence expectedSequence) {
            Preconditions.checkNotNull(expectedSequence);
            String expected = expectedSequence.toString();
            if (StringSubject.this.actual == null) {
                StringSubject.this.failWithoutActual(Fact.fact("expected a string that does not contain", expected), StringSubject.this.butWas(), Fact.simpleFact("(case is ignored)"));
            } else if (this.containsIgnoreCase(expected)) {
                StringSubject.this.failWithoutActual(Fact.fact("expected not to contain", expected), StringSubject.this.butWas(), Fact.simpleFact("(case is ignored)"));
            }
        }

        private boolean containsIgnoreCase(String string) {
            Preconditions.checkNotNull(string);
            if (string.isEmpty()) {
                return true;
            }
            String subject = Preconditions.checkNotNull(StringSubject.this.actual);
            for (int subjectOffset = 0; subjectOffset <= subject.length() - string.length(); ++subjectOffset) {
                if (!subject.regionMatches(true, subjectOffset, string, 0, string.length())) continue;
                return true;
            }
            return false;
        }
    }
}

