/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent.testing;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;

@GwtIncompatible
public class MockFutureListener
implements Runnable {
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private final ListenableFuture<?> future;

    public MockFutureListener(ListenableFuture<?> future) {
        this.future = future;
        future.addListener(this, MoreExecutors.directExecutor());
    }

    @Override
    public void run() {
        this.countDownLatch.countDown();
    }

    public void assertSuccess(Object expectedData) throws Throwable {
        Assert.assertTrue(this.countDownLatch.await(1L, TimeUnit.SECONDS));
        try {
            Assert.assertEquals(expectedData, this.future.get());
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    public void assertException(Throwable expectedCause) throws Exception {
        Assert.assertTrue(this.countDownLatch.await(1L, TimeUnit.SECONDS));
        try {
            this.future.get();
            Assert.fail("This call was supposed to throw an ExecutionException");
        }
        catch (ExecutionException expected) {
            Assert.assertSame(expectedCause, expected.getCause());
        }
    }

    public void assertTimeout() throws Exception {
        Assert.assertFalse(this.countDownLatch.await(1L, TimeUnit.SECONDS));
    }
}

