/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent.testing;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ForwardingListenableFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@GwtIncompatible
class SameThreadScheduledExecutorService
extends AbstractExecutorService
implements ListeningScheduledExecutorService {
    private final ListeningExecutorService delegate = MoreExecutors.newDirectExecutorService();

    SameThreadScheduledExecutorService() {
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        Preconditions.checkNotNull(unit, "unit must not be null!");
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> ListenableFuture<T> submit(Callable<T> task) {
        Preconditions.checkNotNull(task, "task must not be null!");
        return this.delegate.submit((Callable)task);
    }

    @Override
    public <T> ListenableFuture<T> submit(Runnable task, T result) {
        Preconditions.checkNotNull(task, "task must not be null!");
        Preconditions.checkNotNull(result, "result must not be null!");
        return this.delegate.submit(task, (Object)result);
    }

    @Override
    public ListenableFuture<?> submit(Runnable task) {
        Preconditions.checkNotNull(task, "task must not be null!");
        return this.delegate.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        Preconditions.checkNotNull(tasks, "tasks must not be null!");
        return this.delegate.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        Preconditions.checkNotNull(tasks, "tasks must not be null!");
        Preconditions.checkNotNull(unit, "unit must not be null!");
        return this.delegate.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        Preconditions.checkNotNull(tasks, "tasks must not be null!");
        return this.delegate.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Preconditions.checkNotNull(tasks, "tasks must not be null!");
        Preconditions.checkNotNull(unit, "unit must not be null!");
        return this.delegate.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        Preconditions.checkNotNull(command, "command must not be null!");
        this.delegate.execute(command);
    }

    @Override
    public ListenableScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        Preconditions.checkNotNull(command, "command must not be null");
        Preconditions.checkNotNull(unit, "unit must not be null!");
        return this.schedule((Callable)Executors.callable(command), delay, unit);
    }

    @Override
    public <V> ListenableScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        Preconditions.checkNotNull(callable, "callable must not be null!");
        Preconditions.checkNotNull(unit, "unit must not be null!");
        Future delegateFuture = this.submit(callable);
        return new ImmediateScheduledFuture(delegateFuture);
    }

    @Override
    public ListenableScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        throw new UnsupportedOperationException("scheduleAtFixedRate is not supported.");
    }

    @Override
    public ListenableScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        throw new UnsupportedOperationException("scheduleWithFixedDelay is not supported.");
    }

    private static class ImmediateScheduledFuture<V>
    extends ForwardingListenableFuture.SimpleForwardingListenableFuture<V>
    implements ListenableScheduledFuture<V> {
        private ExecutionException exception;

        protected ImmediateScheduledFuture(ListenableFuture<V> future) {
            super(future);
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            Preconditions.checkNotNull(unit, "unit must not be null!");
            return this.get();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            Preconditions.checkNotNull(unit, "unit must not be null!");
            return 0L;
        }

        @Override
        public int compareTo(Delayed other) {
            Preconditions.checkNotNull(other, "other must not be null!");
            return 0;
        }
    }
}

