/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.metrics;

import io.opencensus.internal.Utils;
import io.opencensus.metrics.LabelKey;
import io.opencensus.metrics.LabelValue;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class DoubleGauge {
    public abstract DoublePoint getOrCreateTimeSeries(List<LabelValue> var1);

    public abstract DoublePoint getDefaultTimeSeries();

    public abstract void removeTimeSeries(List<LabelValue> var1);

    public abstract void clear();

    static DoubleGauge newNoopDoubleGauge(String name, String description, String unit, List<LabelKey> labelKeys) {
        return NoopDoubleGauge.create(name, description, unit, labelKeys);
    }

    private static final class NoopDoubleGauge
    extends DoubleGauge {
        private final int labelKeysSize;

        static NoopDoubleGauge create(String name, String description, String unit, List<LabelKey> labelKeys) {
            return new NoopDoubleGauge(name, description, unit, labelKeys);
        }

        NoopDoubleGauge(String name, String description, String unit, List<LabelKey> labelKeys) {
            Utils.checkNotNull(name, "name");
            Utils.checkNotNull(description, "description");
            Utils.checkNotNull(unit, "unit");
            Utils.checkListElementNotNull(Utils.checkNotNull(labelKeys, "labelKeys"), "labelKey element should not be null.");
            this.labelKeysSize = labelKeys.size();
        }

        @Override
        public NoopDoublePoint getOrCreateTimeSeries(List<LabelValue> labelValues) {
            Utils.checkListElementNotNull(Utils.checkNotNull(labelValues, "labelValues"), "labelValue element should not be null.");
            Utils.checkArgument(this.labelKeysSize == labelValues.size(), "Incorrect number of labels.");
            return NoopDoublePoint.INSTANCE;
        }

        @Override
        public NoopDoublePoint getDefaultTimeSeries() {
            return NoopDoublePoint.INSTANCE;
        }

        @Override
        public void removeTimeSeries(List<LabelValue> labelValues) {
            Utils.checkNotNull(labelValues, "labelValues");
        }

        @Override
        public void clear() {
        }

        private static final class NoopDoublePoint
        extends DoublePoint {
            private static final NoopDoublePoint INSTANCE = new NoopDoublePoint();

            private NoopDoublePoint() {
            }

            @Override
            public void add(double amt) {
            }

            @Override
            public void set(double val) {
            }
        }
    }

    public static abstract class DoublePoint {
        public abstract void add(double var1);

        public abstract void set(double var1);
    }
}

