/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.metrics.export;

import io.opencensus.common.Timestamp;
import io.opencensus.metrics.export.Distribution;
import java.util.Map;

final class AutoValue_Distribution_Exemplar
extends Distribution.Exemplar {
    private final double value;
    private final Timestamp timestamp;
    private final Map<String, String> attachments;

    AutoValue_Distribution_Exemplar(double value, Timestamp timestamp, Map<String, String> attachments) {
        this.value = value;
        if (timestamp == null) {
            throw new NullPointerException("Null timestamp");
        }
        this.timestamp = timestamp;
        if (attachments == null) {
            throw new NullPointerException("Null attachments");
        }
        this.attachments = attachments;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Map<String, String> getAttachments() {
        return this.attachments;
    }

    public String toString() {
        return "Exemplar{value=" + this.value + ", timestamp=" + this.timestamp + ", attachments=" + this.attachments + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Distribution.Exemplar) {
            Distribution.Exemplar that = (Distribution.Exemplar)o;
            return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(that.getValue()) && this.timestamp.equals(that.getTimestamp()) && this.attachments.equals(that.getAttachments());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.value) >>> 32 ^ Double.doubleToLongBits(this.value));
        h$ *= 1000003;
        h$ ^= this.timestamp.hashCode();
        h$ *= 1000003;
        return h$ ^= this.attachments.hashCode();
    }
}

