/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.metrics.export;

import com.google.auto.value.AutoValue;
import io.opencensus.common.Function;
import io.opencensus.common.Timestamp;
import io.opencensus.internal.Utils;
import io.opencensus.metrics.export.AutoValue_Distribution;
import io.opencensus.metrics.export.AutoValue_Distribution_Bucket;
import io.opencensus.metrics.export.AutoValue_Distribution_BucketOptions_ExplicitOptions;
import io.opencensus.metrics.export.AutoValue_Distribution_Exemplar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
public abstract class Distribution {
    Distribution() {
    }

    public static Distribution create(long count, double sum, double sumOfSquaredDeviations, BucketOptions bucketOptions, List<Bucket> buckets) {
        Utils.checkArgument(count >= 0L, "count should be non-negative.");
        Utils.checkArgument(sumOfSquaredDeviations >= 0.0, "sum of squared deviations should be non-negative.");
        if (count == 0L) {
            Utils.checkArgument(sum == 0.0, "sum should be 0 if count is 0.");
            Utils.checkArgument(sumOfSquaredDeviations == 0.0, "sum of squared deviations should be 0 if count is 0.");
        }
        Utils.checkNotNull(bucketOptions, "bucketOptions");
        List<Bucket> bucketsCopy = Collections.unmodifiableList(new ArrayList(Utils.checkNotNull(buckets, "buckets")));
        Utils.checkListElementNotNull(bucketsCopy, "bucket");
        return new AutoValue_Distribution(count, sum, sumOfSquaredDeviations, bucketOptions, bucketsCopy);
    }

    public abstract long getCount();

    public abstract double getSum();

    public abstract double getSumOfSquaredDeviations();

    @Nullable
    public abstract BucketOptions getBucketOptions();

    public abstract List<Bucket> getBuckets();

    @Immutable
    public static abstract class BucketOptions {
        private BucketOptions() {
        }

        public static BucketOptions explicitOptions(List<Double> bucketBoundaries) {
            return ExplicitOptions.create(bucketBoundaries);
        }

        public abstract <T> T match(Function<? super ExplicitOptions, T> var1, Function<? super BucketOptions, T> var2);

        @AutoValue
        @Immutable
        public static abstract class ExplicitOptions
        extends BucketOptions {
            ExplicitOptions() {
            }

            @Override
            public final <T> T match(Function<? super ExplicitOptions, T> explicitFunction, Function<? super BucketOptions, T> defaultFunction) {
                return explicitFunction.apply(this);
            }

            private static ExplicitOptions create(List<Double> bucketBoundaries) {
                Utils.checkNotNull(bucketBoundaries, "bucketBoundaries");
                List<Double> bucketBoundariesCopy = Collections.unmodifiableList(new ArrayList<Double>(bucketBoundaries));
                ExplicitOptions.checkBucketBoundsAreSorted(bucketBoundariesCopy);
                return new AutoValue_Distribution_BucketOptions_ExplicitOptions(bucketBoundariesCopy);
            }

            private static void checkBucketBoundsAreSorted(List<Double> bucketBoundaries) {
                if (bucketBoundaries.size() >= 1) {
                    double previous = Utils.checkNotNull(bucketBoundaries.get(0), "bucketBoundary");
                    Utils.checkArgument(previous > 0.0, "bucket boundary should be > 0");
                    for (int i = 1; i < bucketBoundaries.size(); ++i) {
                        double next = Utils.checkNotNull(bucketBoundaries.get(i), "bucketBoundary");
                        Utils.checkArgument(previous < next, "bucket boundaries not sorted.");
                        previous = next;
                    }
                }
            }

            public abstract List<Double> getBucketBoundaries();
        }
    }

    @Immutable
    @AutoValue
    public static abstract class Exemplar {
        Exemplar() {
        }

        public abstract double getValue();

        public abstract Timestamp getTimestamp();

        public abstract Map<String, String> getAttachments();

        public static Exemplar create(double value, Timestamp timestamp, Map<String, String> attachments) {
            Utils.checkNotNull(attachments, "attachments");
            Map<String, String> attachmentsCopy = Collections.unmodifiableMap(new HashMap<String, String>(attachments));
            for (Map.Entry<String, String> entry : attachmentsCopy.entrySet()) {
                Utils.checkNotNull(entry.getKey(), "key of attachments");
                Utils.checkNotNull(entry.getValue(), "value of attachments");
            }
            return new AutoValue_Distribution_Exemplar(value, timestamp, attachmentsCopy);
        }
    }

    @AutoValue
    @Immutable
    public static abstract class Bucket {
        Bucket() {
        }

        public static Bucket create(long count) {
            Utils.checkArgument(count >= 0L, "bucket count should be non-negative.");
            return new AutoValue_Distribution_Bucket(count, null);
        }

        public static Bucket create(long count, Exemplar exemplar) {
            Utils.checkArgument(count >= 0L, "bucket count should be non-negative.");
            Utils.checkNotNull(exemplar, "exemplar");
            return new AutoValue_Distribution_Bucket(count, exemplar);
        }

        public abstract long getCount();

        @Nullable
        public abstract Exemplar getExemplar();
    }
}

