/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.stats;

import com.google.auto.value.AutoValue;
import io.opencensus.internal.Utils;
import io.opencensus.stats.AutoValue_BucketBoundaries;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class BucketBoundaries {
    public static final BucketBoundaries create(List<Double> bucketBoundaries) {
        Utils.checkNotNull(bucketBoundaries, "bucketBoundaries");
        ArrayList<Double> bucketBoundariesCopy = new ArrayList<Double>(bucketBoundaries);
        if (bucketBoundariesCopy.size() > 1) {
            double lower = (Double)bucketBoundariesCopy.get(0);
            for (int i = 1; i < bucketBoundariesCopy.size(); ++i) {
                double next = (Double)bucketBoundariesCopy.get(i);
                Utils.checkArgument(lower < next, "Bucket boundaries not sorted.");
                lower = next;
            }
        }
        return new AutoValue_BucketBoundaries(Collections.unmodifiableList(bucketBoundariesCopy));
    }

    public abstract List<Double> getBoundaries();
}

