/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.trace.config;

import io.opencensus.trace.Sampler;
import io.opencensus.trace.config.TraceParams;

final class AutoValue_TraceParams
extends TraceParams {
    private final Sampler sampler;
    private final int maxNumberOfAttributes;
    private final int maxNumberOfAnnotations;
    private final int maxNumberOfMessageEvents;
    private final int maxNumberOfLinks;

    private AutoValue_TraceParams(Sampler sampler, int maxNumberOfAttributes, int maxNumberOfAnnotations, int maxNumberOfMessageEvents, int maxNumberOfLinks) {
        this.sampler = sampler;
        this.maxNumberOfAttributes = maxNumberOfAttributes;
        this.maxNumberOfAnnotations = maxNumberOfAnnotations;
        this.maxNumberOfMessageEvents = maxNumberOfMessageEvents;
        this.maxNumberOfLinks = maxNumberOfLinks;
    }

    @Override
    public Sampler getSampler() {
        return this.sampler;
    }

    @Override
    public int getMaxNumberOfAttributes() {
        return this.maxNumberOfAttributes;
    }

    @Override
    public int getMaxNumberOfAnnotations() {
        return this.maxNumberOfAnnotations;
    }

    @Override
    public int getMaxNumberOfMessageEvents() {
        return this.maxNumberOfMessageEvents;
    }

    @Override
    public int getMaxNumberOfLinks() {
        return this.maxNumberOfLinks;
    }

    public String toString() {
        return "TraceParams{sampler=" + this.sampler + ", maxNumberOfAttributes=" + this.maxNumberOfAttributes + ", maxNumberOfAnnotations=" + this.maxNumberOfAnnotations + ", maxNumberOfMessageEvents=" + this.maxNumberOfMessageEvents + ", maxNumberOfLinks=" + this.maxNumberOfLinks + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TraceParams) {
            TraceParams that = (TraceParams)o;
            return this.sampler.equals(that.getSampler()) && this.maxNumberOfAttributes == that.getMaxNumberOfAttributes() && this.maxNumberOfAnnotations == that.getMaxNumberOfAnnotations() && this.maxNumberOfMessageEvents == that.getMaxNumberOfMessageEvents() && this.maxNumberOfLinks == that.getMaxNumberOfLinks();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.sampler.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxNumberOfAttributes;
        h$ *= 1000003;
        h$ ^= this.maxNumberOfAnnotations;
        h$ *= 1000003;
        h$ ^= this.maxNumberOfMessageEvents;
        h$ *= 1000003;
        return h$ ^= this.maxNumberOfLinks;
    }

    @Override
    public TraceParams.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends TraceParams.Builder {
        private Sampler sampler;
        private int maxNumberOfAttributes;
        private int maxNumberOfAnnotations;
        private int maxNumberOfMessageEvents;
        private int maxNumberOfLinks;
        private byte set$0;

        Builder() {
        }

        private Builder(TraceParams source) {
            this.sampler = source.getSampler();
            this.maxNumberOfAttributes = source.getMaxNumberOfAttributes();
            this.maxNumberOfAnnotations = source.getMaxNumberOfAnnotations();
            this.maxNumberOfMessageEvents = source.getMaxNumberOfMessageEvents();
            this.maxNumberOfLinks = source.getMaxNumberOfLinks();
            this.set$0 = (byte)15;
        }

        @Override
        public TraceParams.Builder setSampler(Sampler sampler) {
            if (sampler == null) {
                throw new NullPointerException("Null sampler");
            }
            this.sampler = sampler;
            return this;
        }

        @Override
        public TraceParams.Builder setMaxNumberOfAttributes(int maxNumberOfAttributes) {
            this.maxNumberOfAttributes = maxNumberOfAttributes;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public TraceParams.Builder setMaxNumberOfAnnotations(int maxNumberOfAnnotations) {
            this.maxNumberOfAnnotations = maxNumberOfAnnotations;
            this.set$0 = (byte)(this.set$0 | 2);
            return this;
        }

        @Override
        public TraceParams.Builder setMaxNumberOfMessageEvents(int maxNumberOfMessageEvents) {
            this.maxNumberOfMessageEvents = maxNumberOfMessageEvents;
            this.set$0 = (byte)(this.set$0 | 4);
            return this;
        }

        @Override
        public TraceParams.Builder setMaxNumberOfLinks(int maxNumberOfLinks) {
            this.maxNumberOfLinks = maxNumberOfLinks;
            this.set$0 = (byte)(this.set$0 | 8);
            return this;
        }

        @Override
        TraceParams autoBuild() {
            if (this.set$0 != 15 || this.sampler == null) {
                StringBuilder missing = new StringBuilder();
                if (this.sampler == null) {
                    missing.append(" sampler");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" maxNumberOfAttributes");
                }
                if ((this.set$0 & 2) == 0) {
                    missing.append(" maxNumberOfAnnotations");
                }
                if ((this.set$0 & 4) == 0) {
                    missing.append(" maxNumberOfMessageEvents");
                }
                if ((this.set$0 & 8) == 0) {
                    missing.append(" maxNumberOfLinks");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_TraceParams(this.sampler, this.maxNumberOfAttributes, this.maxNumberOfAnnotations, this.maxNumberOfMessageEvents, this.maxNumberOfLinks);
        }
    }
}

