/*
 * Decompiled with CFR 0.152.
 */
package junitparams;

import java.util.List;
import junitparams.internal.DescribableFrameworkMethod;
import junitparams.internal.InstanceFrameworkMethod;
import junitparams.internal.InvokableFrameworkMethod;
import junitparams.internal.MethodBlockSupplier;
import junitparams.internal.NonParameterisedFrameworkMethod;
import junitparams.internal.ParameterisedFrameworkMethod;
import junitparams.internal.TestMethod;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class JUnitParamsRunner
extends BlockJUnit4ClassRunner {
    private final MethodBlockSupplier methodBlockSupplier = new MethodBlockSupplier(){

        @Override
        public Statement getMethodBlock(InvokableFrameworkMethod method) {
            return JUnitParamsRunner.this.methodBlock(method);
        }
    };

    public JUnitParamsRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    @Override
    protected void collectInitializationErrors(List<Throwable> errors) {
        super.validateFields(errors);
        for (Throwable throwable : errors) {
            throwable.printStackTrace();
        }
    }

    @Override
    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        DescribableFrameworkMethod describableMethod = this.getDescribableMethod(method);
        if (this.handleIgnored(describableMethod, notifier)) {
            return;
        }
        if (method instanceof ParameterisedFrameworkMethod) {
            ParameterisedFrameworkMethod parameterisedFrameworkMethod = (ParameterisedFrameworkMethod)method;
            List<InstanceFrameworkMethod> methods = parameterisedFrameworkMethod.getMethods();
            for (InstanceFrameworkMethod frameworkMethod : methods) {
                frameworkMethod.run(this.methodBlockSupplier, notifier);
            }
        } else if (describableMethod instanceof InvokableFrameworkMethod) {
            ((InvokableFrameworkMethod)describableMethod).run(this.methodBlockSupplier, notifier);
        } else {
            throw new IllegalStateException("Unsupported FrameworkMethod class: " + method.getClass());
        }
    }

    private DescribableFrameworkMethod getDescribableMethod(FrameworkMethod method) {
        if (!(method instanceof DescribableFrameworkMethod)) {
            throw new IllegalArgumentException("Unsupported FrameworkMethod class: " + method.getClass() + ", expected a DescribableFrameworkMethod subclass");
        }
        return (DescribableFrameworkMethod)method;
    }

    private boolean handleIgnored(DescribableFrameworkMethod method, RunNotifier notifier) {
        boolean ignored;
        boolean bl = ignored = method instanceof NonParameterisedFrameworkMethod && ((NonParameterisedFrameworkMethod)method).isIgnored();
        if (ignored) {
            notifier.fireTestIgnored(method.getDescription());
        }
        return ignored;
    }

    @Override
    protected List<FrameworkMethod> computeTestMethods() {
        return TestMethod.listFrom(this.getTestClass());
    }

    @Override
    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        if (method instanceof InvokableFrameworkMethod) {
            return ((InvokableFrameworkMethod)method).getInvokeStatement(test);
        }
        throw new IllegalStateException("Unsupported FrameworkMethod class: " + method.getClass() + ", expected an InvokableFrameworkMethod subclass");
    }

    @Override
    protected Description describeChild(FrameworkMethod method) {
        return this.getDescribableMethod(method).getDescription();
    }

    @Deprecated
    public static Object[] $(Object ... params) {
        return params;
    }
}

